/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.software.updater.net;

import de.sillysky.nyssr.address.CNodeId;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.common.CWellKnownNID;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.impl.software.updater.net.CDirectoryWatcher;
import de.sillysky.nyssr.impl.software.updater.net.IDependencies;
import de.sillysky.nyssr.impl.software.updater.net.records.CRecordSoftwareUpdateIncomingJarList;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonBoolean;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonString;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonStringList;
import de.sillysky.nyssr.kernel.configuration.IKernelConfiguration;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.software.updater.records.CRecordSetPluginList;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.util.files.CUtilPath;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.prefs.Preferences;
import org.jetbrains.annotations.NotNull;

class CSoftwareUpdaterTarget
extends CTarget
implements IService {
    private static final ILogger LOG = CLoggerFactory.getLogger(CSoftwareUpdaterTarget.class);
    private final IDependencies mDependencies;
    private CDirectoryWatcher mDirectoryWatcher;

    CSoftwareUpdaterTarget(@NotNull IDependencies aDependencies) {
        this.mDependencies = aDependencies;
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordSoftwareUpdateIncomingJarList.ID, this::asyncIncomingJarList);
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        INamespace ns = this.mDependencies.getNamespaceRegistry().getNamespace(CWellKnownNID.SYSTEM);
        assert (ns != null);
        ns.getTargetRegistry().registerTarget((ITarget)this);
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        if (this.mDirectoryWatcher != null) {
            this.mDirectoryWatcher.stop();
        }
        this.deregisterTarget();
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws IOException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        IKernelConfiguration kc = this.mDependencies.getKernelConfiguration();
        Path storagePath = kc.getStoragePath();
        if (storagePath == null) {
            LOG.error("No storage path");
        } else {
            boolean success;
            Preferences preferences = kc.getPreferences("software.updater.net");
            String path = preferences.get("incoming_jar_lists", "incoming_jar_lists");
            Path basePath = CUtilPath.resolvePath((String)storagePath.toString(), (String)path);
            File dir = basePath.toFile();
            if (!dir.exists() && !(success = basePath.toFile().mkdirs())) {
                throw new IOException("Failed to create directory " + basePath);
            }
            this.mDirectoryWatcher = new CDirectoryWatcher(this.mDependencies, basePath, this.getAddress());
            this.mDirectoryWatcher.start();
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncIncomingJarList(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        String content = CRecordSoftwareUpdateIncomingJarList.getFileContent(aRecord, "");
        try {
            CJsonObject obj = this.mDependencies.getJsonParser().parse(content, false);
            Object o = obj.getValue("jar_list");
            if (o instanceof CJsonObject) {
                CJsonObject main = (CJsonObject)o;
                List nodes = CUtilJsonStringList.fromJson((CJsonObject)main, (String)"nodes");
                boolean reboot = CUtilJsonBoolean.fromJson((CJsonObject)main, (String)"reboot", (boolean)false);
                String sessionToken = CUtilJsonString.fromJson((CJsonObject)main, (String)"sessionToken", null);
                List libs = CUtilJsonStringList.fromJson((CJsonObject)main, (String)"libraries");
                List plugins = CUtilJsonStringList.fromJson((CJsonObject)main, (String)"plugins");
                List pluginsToLoad = CUtilJsonStringList.fromJson((CJsonObject)main, (String)"pluginsToLoad");
                for (String node : nodes) {
                    CIdFactory.fromObject((Object)CRecordSetPluginList.NAMESPACES[0]);
                    CEnvelope env = CEnvelope.forRemoteNanoService((IId)CWellKnownNID.SYSTEM, (CNodeId)new CNodeId(node));
                    CRecord record = CRecordSetPluginList.create();
                    CRecordSetPluginList.setLibraryList((CRecord)record, (String[])libs.toArray(new String[0]));
                    CRecordSetPluginList.setPluginList((CRecord)record, (String[])plugins.toArray(new String[0]));
                    CRecordSetPluginList.setPluginToLoadList((CRecord)record, (String[])pluginsToLoad.toArray(new String[0]));
                    CRecordSetPluginList.setReboot((CRecord)record, (boolean)reboot);
                    CRecordSetPluginList.setSessionToken((CRecord)record, (String)sessionToken);
                    this.sendRequest(env, record);
                }
                aEnvelope.setResultSuccess();
            }
        }
        catch (CException ignore) {
            aEnvelope.setResult(19, "Parsing error");
        }
        return true;
    }
}

