/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.software.updater.net;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.impl.software.updater.net.IDependencies;
import de.sillysky.nyssr.impl.software.updater.net.records.CRecordSoftwareUpdateIncomingJarList;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.util.files.CUtilFile;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;

class CFileReadRunnable
implements Runnable {
    private static final ILogger LOG = CLoggerFactory.getLogger(CFileReadRunnable.class);
    private final IDependencies mDependencies;
    private final Path mFilePath;
    private final CTargetAddress mAddress;

    CFileReadRunnable(@NotNull IDependencies aDependencies, @NotNull Path aFilePath, @NotNull CTargetAddress aAddress) {
        this.mDependencies = aDependencies;
        this.mFilePath = aFilePath;
        this.mAddress = aAddress;
    }

    @Override
    public void run() {
        try {
            this.waitForFileAvailability();
            this.readFile();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (IOException e) {
            LOG.error("IO Error occurred: {}", new Object[]{e.getMessage()});
        }
    }

    private void waitForFileAvailability() throws InterruptedException {
        File file = this.mFilePath.toFile();
        while (!file.exists() || !file.canRead()) {
            Thread.sleep(200L);
        }
    }

    private void readFile() throws IOException {
        try {
            String content = CUtilFile.readTextFile((Path)this.mFilePath, (Charset)StandardCharsets.UTF_8);
            CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)this.mAddress);
            env.setSender(this.mAddress);
            CRecord record = CRecordSoftwareUpdateIncomingJarList.create();
            CRecordSoftwareUpdateIncomingJarList.setFileContent(record, content);
            this.mDependencies.getMessageSender().sendNotification(env, record);
            boolean deleted = this.mFilePath.toFile().delete();
            if (!deleted) {
                LOG.warn("Couldn't delete file {}", new Object[]{this.mFilePath});
            }
        }
        catch (CException | IOException ignore) {
            LOG.error("Couldn't read file content from {}", new Object[]{this.mFilePath});
        }
    }
}

