/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.microservice.registry.target2;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.impl.microservice.registry.records.CRecordNotifyMicroServiceInstanceAdded;
import de.sillysky.nyssr.impl.microservice.registry.records.CRecordNotifyMicroServiceInstanceRemoved;
import de.sillysky.nyssr.impl.microservice.registry.records.CRecordRequestMicroServiceUpdate;
import de.sillysky.nyssr.impl.microservice.registry.service.IMicroServiceRegistry;
import de.sillysky.nyssr.impl.microservice.registry.target2.CUpdate;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.microservice.collector.CMicroServiceDescription;
import de.sillysky.nyssr.microservice.registry.broadcast.records.CRecordBroadcastMicroServiceRegistryCreated;
import de.sillysky.nyssr.microservice.registry.broadcast.records.CRecordBroadcastMicroServiceRegistryDeleted;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.namespace.INamespaceFactory;
import de.sillysky.nyssr.notification.records.CRecordNotifyRemoteNodeRemoved;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CTargetForOtherRegistries
extends CTarget
implements IService {
    private static final ILogger LOG = CLoggerFactory.getLogger(CTargetForOtherRegistries.class);
    private static final IId[] OBSERVED = new IId[]{CRecordNotifyMicroServiceInstanceRemoved.ID, CRecordNotifyMicroServiceInstanceAdded.ID, CRecordNotifyRemoteNodeRemoved.ID};
    private IMicroServiceRegistry mRegistry;
    private INamespace mNamespace;

    public CTargetForOtherRegistries() {
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordNotifyMicroServiceInstanceRemoved.ID, this::asyncNotifyMicroServiceInstanceRemoved);
        this.addMessageHandler(CRecordNotifyMicroServiceInstanceAdded.ID, this::asyncNotifyMicroServiceInstanceAdded);
        this.addMessageHandler(CRecordBroadcastMicroServiceRegistryCreated.ID, this::asyncBroadcastMicroServiceRegistryCreated);
        this.addMessageHandler(CRecordBroadcastMicroServiceRegistryDeleted.ID, this::asyncBroadcastMicroServiceRegistryDeleted);
        this.addMessageHandler(CRecordRequestMicroServiceUpdate.ID, this::asyncRequestMicroServiceUpdate);
        this.addMessageHandler(CRecordNotifyRemoteNodeRemoved.ID, this::asyncNotifyRemoteNodeRemoved);
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        this.mRegistry = (IMicroServiceRegistry)aServiceRegistry.getServiceOrThrow(IMicroServiceRegistry.class);
        INamespaceFactory nsf = (INamespaceFactory)aServiceRegistry.getServiceOrThrow(INamespaceFactory.class);
        IId nid = CIdFactory.random((String)"MicroServiceRegistry");
        this.mNamespace = nsf.createAndRegisterNamespace(nid, "MicroServiceRegistry");
        this.mNamespace.getTargetRegistry().registerTarget((ITarget)this);
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        this.deregisterTarget();
    }

    private boolean asyncBroadcastMicroServiceRegistryCreated(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CTargetAddress address = CRecordBroadcastMicroServiceRegistryCreated.getMicroServiceAddress((CRecord)aRecord, null);
        CUtilCheck.checkNotNull((Object)address, (String)"Address is empty", (Object[])new Object[0]);
        this.mRegistry.addOtherRegistry(address);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncBroadcastMicroServiceRegistryDeleted(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CTargetAddress address = CRecordBroadcastMicroServiceRegistryDeleted.getMicroServiceAddress((CRecord)aRecord, null);
        CUtilCheck.checkNotNull((Object)address, (String)"Address is empty", (Object[])new Object[0]);
        this.mRegistry.removeOtherRegistry(address);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncNotifyMicroServiceInstanceRemoved(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        IId id = CRecordNotifyMicroServiceInstanceRemoved.getMicroServiceId(aRecord, null);
        CUtilCheck.checkNotNull((Object)id, (String)"MicroService ID missing", (Object[])new Object[0]);
        IId instanceId = CRecordNotifyMicroServiceInstanceRemoved.getInstanceId(aRecord, null);
        CUtilCheck.checkNotNull((Object)instanceId, (String)"Instance ID missing", (Object[])new Object[0]);
        this.mRegistry.removeMicroService(id, instanceId, false);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncNotifyMicroServiceInstanceAdded(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CRecord rec = CRecordNotifyMicroServiceInstanceAdded.getMicroService(aRecord, null);
        CUtilCheck.checkNotNull((Object)rec, (String)"MicroService missing", (Object[])new Object[0]);
        CMicroServiceDescription desc = CMicroServiceDescription.fromRecord((CRecord)aRecord);
        IId instanceId = CRecordNotifyMicroServiceInstanceAdded.getInstanceId(aRecord, null);
        CUtilCheck.checkNotNull((Object)instanceId, (String)"Instance ID missing", (Object[])new Object[0]);
        CTargetAddress address = CRecordNotifyMicroServiceInstanceAdded.getAddress(aRecord, null);
        CUtilCheck.checkNotNull((Object)address, (String)"Instance address missing", (Object[])new Object[0]);
        this.mRegistry.addMicroService(instanceId, address, desc, false);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncNotifyRemoteNodeRemoved(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CNodeAddress node = CRecordNotifyRemoteNodeRemoved.getRemoteNode((CRecord)aRecord, null);
        CUtilCheck.checkNotNull((Object)node, (String)"Node Address missing", (Object[])new Object[0]);
        this.mRegistry.notifyNodeDeleted(node);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncRequestMicroServiceUpdate(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            CUpdate.fromRecord(this.mRegistry, aRecord);
        } else {
            CUpdate.toRecord(this.mRegistry, aRecord);
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.mNamespace.getNanoServiceRegistry().addObservers(OBSERVED, this.getAddress());
        aEnvelope.setResultSuccess();
        return true;
    }

    public void deactivate() {
        this.deregisterTarget();
    }

    void notifyInstanceAdded(@NotNull CMicroServiceDescription aMicroService, @NotNull IId aInstanceId, @NotNull CTargetAddress aInstanceAddress) {
        Collection<CTargetAddress> rr = this.mRegistry.getOtherRegistries();
        ArrayList<CTargetAddress> errors = new ArrayList<CTargetAddress>();
        for (CTargetAddress r : rr) {
            try {
                CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)r);
                CRecord rec = CRecordNotifyMicroServiceInstanceAdded.create();
                CRecord rec2 = aMicroService.valueToRecord();
                CRecordNotifyMicroServiceInstanceAdded.setMicroService(rec, rec2);
                CRecordNotifyMicroServiceInstanceAdded.setInstanceId(rec, aInstanceId);
                CRecordNotifyMicroServiceInstanceAdded.setAddress(rec, aInstanceAddress);
                this.sendNotification(env, rec);
            }
            catch (CException e) {
                LOG.error((Throwable)e, "Error sending notifyInstanceAdded to {}", new Object[]{r});
                errors.add(r);
            }
        }
        this.removeInvalidAddressesOfOtherRegistries(errors);
    }

    void notifyInstanceRemoved(@NotNull IId aMicroServiceId, @NotNull IId aInstanceId, @NotNull CTargetAddress aInstanceAddress) {
        Collection<CTargetAddress> rr = this.mRegistry.getOtherRegistries();
        ArrayList<CTargetAddress> errors = new ArrayList<CTargetAddress>();
        for (CTargetAddress r : rr) {
            try {
                CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)r);
                CRecord rec = CRecordNotifyMicroServiceInstanceRemoved.create();
                CRecordNotifyMicroServiceInstanceRemoved.setMicroServiceId(rec, aMicroServiceId);
                CRecordNotifyMicroServiceInstanceRemoved.setInstanceId(rec, aInstanceId);
                CRecordNotifyMicroServiceInstanceRemoved.setAddress(rec, aInstanceAddress);
                this.sendNotification(env, rec);
            }
            catch (CException e) {
                LOG.error((Throwable)e, "Error sending notifyInstanceRemoved to {}", new Object[]{r});
                errors.add(r);
            }
        }
        this.removeInvalidAddressesOfOtherRegistries(errors);
    }

    private void removeInvalidAddressesOfOtherRegistries(@NotNull List<CTargetAddress> aErrors) {
        if (!aErrors.isEmpty()) {
            for (CTargetAddress r : aErrors) {
                this.mRegistry.removeOtherRegistry(r);
            }
        }
    }
}

