/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.index.application;

import de.sillysky.nyssr.app.CApplicationDescription;
import de.sillysky.nyssr.app.IApplication;
import de.sillysky.nyssr.app.IApplicationContext;
import de.sillysky.nyssr.app.IApplicationDescription;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.impl.network.index.application.CNetworkApplicationRegistry;
import de.sillysky.nyssr.impl.network.index.application.CTargetNetworkIndex;
import de.sillysky.nyssr.namespace.IRecordHelper;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public class CApplication
implements IApplication {
    static final CApplicationDescription mDesc = new CApplicationDescription(UUID.fromString("d25758a5-a6ac-4843-9559-1b34eea59449"));
    private IApplicationContext mContext;
    private CTargetNetworkIndex mTarget;
    private IRecordHelper mRecordHelper;

    void activate(IRecordHelper aRecordHelper) {
        this.mRecordHelper = aRecordHelper;
    }

    @NotNull
    public IApplicationDescription getDescription() {
        return mDesc;
    }

    @NotNull
    public UUID getInstanceId() {
        return this.mContext.getInstanceId();
    }

    public void notifyStopped() {
    }

    public void pause() {
    }

    public boolean requestStop() {
        return true;
    }

    public void resume() {
    }

    public void start(@NotNull IApplicationContext aContext) throws CException {
        this.mContext = aContext;
        CNetworkApplicationRegistry appRegistry = new CNetworkApplicationRegistry();
        appRegistry.activate();
        this.mTarget = new CTargetNetworkIndex();
        this.mTarget.activate(this.mRecordHelper, appRegistry, this.mContext.getNamespace().getTargetRegistry());
        appRegistry.setTarget(this.mTarget);
    }

    public void stop() {
        this.mTarget.deactivate();
    }

    static {
        mDesc.setName("NetworkIndex");
        mDesc.setShortDescription("An index for the network");
        mDesc.setLongDescription("An index for the network");
    }
}

