/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.microservice.collector;

import de.sillysky.nyssr.impl.microservice.collector.CMicroServiceRegistryCollector;
import de.sillysky.nyssr.impl.microservice.collector.IDependencies;
import de.sillysky.nyssr.message.IMessageSender;
import de.sillysky.nyssr.network.router.IRouter;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.service.IServiceStarter;
import org.jetbrains.annotations.NotNull;

public class CPackageImplMicroServiceCollector
implements IServiceStarter,
IDependencies {
    private IService mService;
    private IRouter mRouter;
    private IMessageSender mMessageSender;

    public void getDependencies(@NotNull IServiceDependencyList aDependencyList) {
        aDependencyList.add(IRouter.class);
        aDependencyList.add(IMessageSender.class);
    }

    public void start(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        if (this.mService == null) {
            this.mRouter = (IRouter)aServiceRegistry.getServiceOrThrow(IRouter.class);
            this.mMessageSender = (IMessageSender)aServiceRegistry.getServiceOrThrow(IMessageSender.class);
            this.mService = new CMicroServiceRegistryCollector(this);
            this.mService.activate(aServiceRegistry);
        }
    }

    public void stop(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        if (this.mService != null) {
            this.mService.deactivate(aServiceRegistry);
            this.mService = null;
        }
    }

    @Override
    public IRouter getRouter() {
        return this.mRouter;
    }

    @Override
    public IMessageSender getMessageSender() {
        return this.mMessageSender;
    }
}

