/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.web.dialog.adduser;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.web.dialog.adduser.CConstants;
import de.sillysky.nyssr.json.CUtilJson;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.remoteskin.web.dialog.records.CRecordWebDismissDialog;
import de.sillysky.nyssr.remoteskin.web.protocol.CWebApi;
import de.sillysky.nyssr.remoteskin.web.protocol.CWebDialogApi;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebNotifyClick1;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebNotifyClick2;
import de.sillysky.nyssr.session.CConstantsSession;
import de.sillysky.nyssr.session.api.CUser;
import de.sillysky.nyssr.session.api.records.CRecordUserDbCreateUser;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.util.CUtilEmail;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.properties.CStringProperties;
import org.jetbrains.annotations.NotNull;

class C00303AddUser
extends CTarget {
    private final byte[] mSessionToken;
    private final CTargetAddress mClientTargetAddress;
    private final CTargetAddress mOwnerTargetAddress;
    private CWebApi mWebApi;
    private CWebDialogApi mWebDialogApi;
    private static final String ID_INDEX_MODAL = "rs_30cb3f8d-cefd-40c5-81b8-7791895c7b95";
    private static final String ID_00303_MODAL = "id_00303_modal";
    private static final String ID_00303_CANCEL = "id_00303_cancel";
    private static final String ID_00303_SAVE = "id_00303_save";
    private static final String ID_00303_USERID = "id_00303_userid";
    private static final String ID_00303_EMAIL = "id_00303_email";
    private static final String ID_00303_PICTURE = "id_00303_picture";
    private static final String ID_00303_REALNAME = "id_00303_realname";
    private static final String ID_00303_PASSWORD1 = "id_00303_password1";
    private static final String ID_00303_PASSWORD2 = "id_00303_password2";
    private static final String ID_00303_USERID_ALERT = "id_00303_userid_alert";
    private static final String ID_00303_EMAIL_ALERT = "id_00303_email_alert";
    private static final String ID_00303_PASSWORD_ALERT = "id_00303_password_alert";
    private static final String[] WIDGETS = new String[]{"id_00303_cancel", "id_00303_save"};
    private final CUser mUser = new CUser();

    public C00303AddUser(byte[] aSessionToken, @NotNull CTargetAddress aClientTargetAddress, @NotNull CTargetAddress aOwnerTargetAddress) {
        this.mSessionToken = aSessionToken;
        this.mClientTargetAddress = aClientTargetAddress;
        this.mOwnerTargetAddress = aOwnerTargetAddress;
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordWebDismissDialog.ID, this::asyncWebDismissDialog);
        this.addMessageHandler(CRecordWebNotifyClick1.ID, this::asyncWebNotifyClick1);
        this.addMessageHandler(CRecordWebNotifyClick2.ID, this::asyncWebNotifyClick2);
        this.addMessageHandler(CRecordUserDbCreateUser.ID, this::asyncUserDbCreateUser);
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.mWebApi = new CWebApi((ITarget)this, this.mClientTargetAddress);
        this.mWebDialogApi = new CWebDialogApi((ITarget)this, this.mClientTargetAddress);
        this.mWebApi.registerWidgets(WIDGETS);
        this.showDialog();
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncWebDismissDialog(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.finish(3);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncWebNotifyClick1(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        boolean errors = false;
        CStringProperties values = CRecordWebNotifyClick1.getValues((CRecord)aRecord, null);
        if (values != null) {
            String userId = values.get(ID_00303_USERID, "");
            this.mUser.setId(userId);
            String realName = values.get(ID_00303_REALNAME, "");
            this.mUser.setRealName(realName);
            String email = values.get(ID_00303_EMAIL, "");
            if (!CUtilEmail.isValidEmail((String)email)) {
                String alert = CUtilJson.loadJson(((Object)((Object)this)).getClass(), (String)"/html/00303_alert.html");
                alert = CUtilString.replaceFirstOccurrence((String)alert, (String)"{message}", (String)"This is not a valid email address.");
                this.mWebApi.setInnerHtml(ID_00303_EMAIL_ALERT, alert);
                errors = true;
            } else {
                this.mUser.setEmail(email);
            }
            String picture = values.get(ID_00303_PICTURE, "");
            this.mUser.setPicture(picture);
            String pw1 = values.get(ID_00303_PASSWORD1, "");
            String pw2 = values.get(ID_00303_PASSWORD2, "");
            if (!pw1.equals(pw2)) {
                String alert = CUtilJson.loadJson(((Object)((Object)this)).getClass(), (String)"/html/00303_alert.html");
                alert = CUtilString.replaceFirstOccurrence((String)alert, (String)"{message}", (String)"The passwords are different.");
                this.mWebApi.setInnerHtml(ID_00303_PASSWORD_ALERT, alert);
                errors = true;
            } else {
                this.mUser.setPassword(pw1);
            }
            if (!errors) {
                this.sendAddUser(this.mUser);
            }
        } else {
            this.finish(1);
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncWebNotifyClick2(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.finish(2);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncUserDbCreateUser(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            int resultCode = aEnvelope.getResultCode();
            if (resultCode == 0) {
                this.finish(0);
            } else {
                String alert = CUtilJson.loadJson(((Object)((Object)this)).getClass(), (String)"/html/00303_alert.html");
                alert = CUtilString.replaceFirstOccurrence((String)alert, (String)"{message}", (String)aEnvelope.getResultText());
                this.mWebApi.setInnerHtml(ID_00303_USERID_ALERT, alert);
            }
            return true;
        }
        return false;
    }

    private void showDialog() throws CException {
        String main = CUtilJson.loadJson(((Object)((Object)this)).getClass(), (String)"/html/00303_main.html");
        this.mWebApi.removeElement(ID_00303_MODAL);
        this.mWebApi.setInnerHtml(ID_INDEX_MODAL, main);
        this.mWebApi.showModal(ID_00303_MODAL);
        this.mWebApi.addClickListener1(ID_00303_SAVE, new String[]{ID_00303_USERID, ID_00303_EMAIL, ID_00303_PICTURE, ID_00303_REALNAME, ID_00303_PASSWORD1, ID_00303_PASSWORD2});
        this.mWebApi.addClickListener2(new String[]{ID_00303_CANCEL});
    }

    void sendAddUser(@NotNull CUser aUser) throws CException {
        CEnvelope env = CEnvelope.forMicroService((IId)CConstantsSession.MICRO_SERVICE_ID);
        env.setSessionToken(this.mSessionToken);
        CRecord record = CRecordUserDbCreateUser.create();
        CRecordUserDbCreateUser.setUserId((CRecord)record, (String)aUser.getId());
        CRecordUserDbCreateUser.setRealName((CRecord)record, (String)aUser.getRealName());
        CRecordUserDbCreateUser.setEmail((CRecord)record, (String)aUser.getEmail());
        CRecordUserDbCreateUser.setPicture((CRecord)record, (String)aUser.getPicture());
        CRecordUserDbCreateUser.setPassword((CRecord)record, (String)aUser.getPassword());
        this.sendRequest(env, record);
    }

    private void finish(int aReason) throws CException {
        this.mWebApi.removeElement(ID_00303_MODAL);
        CStringProperties sp = new CStringProperties();
        sp.put("userId", this.mUser.getId());
        this.mWebDialogApi.notifyDismissed(this.mOwnerTargetAddress, CConstants.MICRO_SERVICE_ID, aReason, sp);
        this.mWebApi.deregisterWidgetOwner();
        this.deregisterTarget();
    }
}

