/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.message.panel;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.widget.CWidgetId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.impl.message.panel.CMessagePanelInstanceModel;
import de.sillysky.nyssr.impl.message.panel.CMessagePanelInstanceUi;
import de.sillysky.nyssr.impl.message.panel.IDependencies;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.message.panel.records.CRecordAddMessages;
import de.sillysky.nyssr.message.panel.records.CRecordClear;
import de.sillysky.nyssr.message.panel.records.CRecordCloseDialog;
import de.sillysky.nyssr.message.panel.records.CRecordShowDialog;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.remoteskin.server.dialog.CBasicDialog;
import de.sillysky.nyssr.remoteskin.server.dialog.CDialogDto;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import java.awt.Color;
import java.util.prefs.Preferences;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CMessagePanelInstanceTarget
extends CBasicDialog {
    private static final ILogger LOG = CLoggerFactory.getLogger((String)"dialog.messagepanel");
    private static final String[] JSON = new String[]{"/json/400_MessagePanel.json", "/json/401_DlgMessageHistory.json"};
    private static final IId TIMER_ID = CIdFactory.fromObject((Object)"MsgPanelTimer");
    private final IDependencies mDependencies;
    private final CMessagePanelInstanceModel mModel;
    private CMessagePanelInstanceUi mUi;

    CMessagePanelInstanceTarget(@NotNull IDependencies aDependencies, @NotNull CDialogDto aDialogDto, @NotNull Preferences aPreferences, int aPanelType, CWidgetId aCenterAbove, @Nullable Color aBackground, @Nullable Color aForeground) {
        super(aDependencies.getNamespaceRegistry(), aDependencies.getServerContextFactory(), aDependencies.getWidgetSetLoader(), aDialogDto);
        this.mDependencies = aDependencies;
        long timerDelay = aPreferences.getLong("timer.message.ms", 2000L);
        boolean hideOnNoMessage = aPreferences.getBoolean("hide.on.no.message", false);
        this.mModel = new CMessagePanelInstanceModel(aDialogDto, aCenterAbove, aPreferences, aPanelType, hideOnNoMessage, timerDelay);
        this.mModel.setBackground(aBackground);
        this.mModel.setForeground(aForeground);
        this.addMessageHandler(TIMER_ID, this::asyncTimer);
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordAddMessages.ID, this::asyncAddMessages);
        this.addMessageHandler(CRecordClear.ID, this::asyncClear);
        this.addMessageHandler(CRecordShowDialog.ID, this::asyncShowDialog);
        this.addMessageHandler(CRecordCloseDialog.ID, this::asyncCloseDialog);
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        LOG.info("Start Preset Target");
        super.startTarget(aEnvelope, aRecord);
        this.mUi = new CMessagePanelInstanceUi(this.mModel);
        this.mUi.mountWidgetSet400();
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncDismissInstance(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.dismiss();
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncAddMessages(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        String[] messages = CRecordAddMessages.getMessages((CRecord)aRecord, null);
        if (messages != null) {
            for (String m : messages) {
                this.addMessage(m);
            }
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncClear(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.mUi.clear();
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncCloseDialog(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.mUi.sendCloseDialog();
        aEnvelope.setResultSuccess();
        return true;
    }

    protected String[] getJsonFiles() {
        return JSON;
    }

    private boolean asyncShowDialog(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.mUi.showHistory();
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncTimer(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        this.mModel.setTimerHandle(0L);
        this.mModel.addEmptyMessage();
        this.mUi.notifyMessageAdded();
        aEnvelope.setResultSuccess();
        return true;
    }

    private void dismiss() {
        this.stopTimer();
        this.deregisterTarget();
    }

    private void startTimer() {
        if (!this.mModel.isTimerRunning()) {
            long timerHandle = this.mDependencies.getTimerManager().createAndStartTimer(TIMER_ID, this.getAddress(), this.mModel.getTimerDelay(), false, null);
            this.mModel.setTimerHandle(timerHandle);
        } else {
            this.mDependencies.getTimerManager().resetTimer(this.mModel.getTimerHandle());
        }
    }

    private void stopTimer() {
        if (this.mModel.isTimerRunning()) {
            this.mDependencies.getTimerManager().dismissTimer(this.mModel.getTimerHandle());
            this.mModel.setTimerHandle(0L);
        }
    }

    void addMessage(@NotNull String aMessage) {
        this.mModel.addMessage(aMessage);
        this.mUi.notifyMessageAdded();
        if (!this.mModel.isEmpty()) {
            this.startTimer();
        } else {
            this.stopTimer();
        }
    }
}

