/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.file.registry.records;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISlot;
import java.time.Instant;
import org.jetbrains.annotations.NotNull;

public final class CRecordFileRegistryFileInfo
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject((Object)"e8994dd7-39e6-4acb-ab91-e680f2daf591");
    public static final String NAME = "FileRegistryFileInfo";
    public static final String DESCRIPTION = "information about a file.";
    public static final String SLOT_HASH = "hash";
    public static final String SLOT_PATH = "path";
    public static final String SLOT_SOURCE_ADDRESS = "adr";
    public static final String SLOT_TIME_OF_LAST_MODIFICATION = "time";
    public static final String[] NAMESPACES = new String[0];
    public static final boolean IS_NANO_SERVICE = false;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static String getHash(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_HASH);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static String getPath(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_PATH);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static CTargetAddress getSourceAddress(@NotNull CRecord aRecord, CTargetAddress aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_SOURCE_ADDRESS);
        if (slot == null) {
            return aDefault;
        }
        return (CTargetAddress)slot.getValue();
    }

    public static Instant getTimeOfLastModification(@NotNull CRecord aRecord, Instant aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_TIME_OF_LAST_MODIFICATION);
        if (slot == null) {
            return aDefault;
        }
        return (Instant)slot.getValue();
    }

    public static void setHash(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING, (Object)aValue);
        aRecord.addSlot(SLOT_HASH, slot);
    }

    public static void setPath(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING, (Object)aValue);
        aRecord.addSlot(SLOT_PATH, slot);
    }

    public static void setSourceAddress(@NotNull CRecord aRecord, CTargetAddress aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.TARGET_ADDRESS, (Object)aValue);
        aRecord.addSlot(SLOT_SOURCE_ADDRESS, slot);
    }

    public static void setTimeOfLastModification(@NotNull CRecord aRecord, Instant aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.INSTANT, (Object)aValue);
        aRecord.addSlot(SLOT_TIME_OF_LAST_MODIFICATION, slot);
    }
}

