/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.server.connector;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.remoteskin.server.connector.IRemoteSkinClientContext;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

class CRemoteSkinClientContextEntry
implements IRemoteSkinClientContext {
    private final IId mContextId;
    private final CNodeAddress mNode;
    private final String mPlatformType;
    private CTargetAddress mTargetAddress;

    CRemoteSkinClientContextEntry(@NotNull IId aContextId, @NotNull CNodeAddress aNode, @NotNull String aPlatformType) {
        this.mContextId = aContextId;
        this.mNode = aNode;
        this.mPlatformType = aPlatformType;
        this.mTargetAddress = null;
    }

    @NotNull
    public IId getId() {
        return this.mContextId;
    }

    public CTargetAddress getTargetAddress() {
        return this.mTargetAddress;
    }

    public CNodeAddress getNode() {
        return this.mNode;
    }

    @NotNull
    public String getPlatformType() {
        return this.mPlatformType;
    }

    public boolean equals(Object aOther) {
        if (this == aOther) {
            return true;
        }
        if (aOther == null || this.getClass() != aOther.getClass()) {
            return false;
        }
        CRemoteSkinClientContextEntry that = (CRemoteSkinClientContextEntry)aOther;
        return this.mContextId.equals((Object)that.mContextId);
    }

    public int hashCode() {
        return Objects.hash(this.mContextId);
    }

    public String toString() {
        return "ClientContext " + this.mContextId + " on Node " + this.mNode + ", TYPE = " + this.mPlatformType;
    }

    void setTargetAddress(CTargetAddress aAddress) {
        this.mTargetAddress = aAddress;
    }
}

