/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.version;

import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.util.CUtilString;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Paths;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jetbrains.annotations.NotNull;

public final class CVersionHelper {
    private static final ILogger LOG = CLoggerFactory.getLogger(CVersionHelper.class);
    private static final String[] ATTRIBUTE_NAMES = new String[]{"Implementation-Title", "SourceCompatibility"};

    private CVersionHelper() {
    }

    private static void printAttribute(@NotNull StringBuilder aSb, @NotNull Attributes aMainAttribs, @NotNull String aAttributeName) {
        String s = aMainAttribs.getValue(aAttributeName);
        if (s != null) {
            aSb.append(aAttributeName);
            aSb.append(": ");
            aSb.append(s);
            aSb.append(CUtilString.CRLF);
        }
    }

    public static void printJarVersion(@NotNull URL aUrl) {
        try {
            URI jarUri = aUrl.toURI();
            URI jarJarUri = URI.create("jar:" + jarUri.toString() + "!/");
            URL jarUrl = jarJarUri.toURL();
            URLConnection urlConnection = jarUrl.openConnection();
            if (urlConnection instanceof JarURLConnection) {
                JarURLConnection jarConnection = (JarURLConnection)urlConnection;
                Manifest manifest = jarConnection.getManifest();
                Attributes mainAttribs = manifest.getMainAttributes();
                StringBuilder sb = new StringBuilder(500);
                sb.append(CUtilString.CRLF);
                sb.append(CUtilString.LINE_CRLF);
                sb.append(Paths.get(aUrl.toURI()).normalize());
                sb.append(CUtilString.CRLF);
                for (String a : ATTRIBUTE_NAMES) {
                    CVersionHelper.printAttribute(sb, mainAttribs, a);
                }
                sb.append(CUtilString.LINE_CRLF);
                LOG.info(sb.toString());
            }
        }
        catch (IOException e) {
            LOG.error("No version info available for URL {}", aUrl.toString());
        }
        catch (URISyntaxException aE) {
            throw new RuntimeException(aE);
        }
    }
}

