/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.time;

import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.time.CUtilZonedDateTime;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CUtilTimestamp {
    private CUtilTimestamp() {
    }

    @Nullable
    public static Timestamp fromLocalDateTime(@Nullable LocalDateTime aLocalDateTime) {
        return aLocalDateTime == null ? null : Timestamp.valueOf(aLocalDateTime);
    }

    @NotNull
    public static Timestamp fromZonedDateTime(@NotNull ZonedDateTime aZonedDateTime) {
        return Timestamp.from(aZonedDateTime.toInstant());
    }

    @NotNull
    public static String toUtcIsoString(@NotNull Timestamp aTimestamp) {
        ZonedDateTime zdt = ZonedDateTime.ofInstant(aTimestamp.toInstant(), ZoneId.of("UTC"));
        return CUtilZonedDateTime.toIsoString(zdt);
    }

    @NotNull
    public static String toIsoString(@NotNull Timestamp aTimestamp) {
        ZonedDateTime zdt = ZonedDateTime.ofInstant(aTimestamp.toInstant(), ZoneId.systemDefault());
        return CUtilZonedDateTime.toIsoString(zdt);
    }

    @Nullable
    public static Timestamp fromUtcIsoString(@NotNull String aValue) {
        if (CUtilString.isEmpty(aValue)) {
            return null;
        }
        ZonedDateTime zdt = CUtilZonedDateTime.fromIsoString(aValue);
        return CUtilTimestamp.fromZonedDateTime(zdt);
    }

    @NotNull
    public static Timestamp fromInstant(@NotNull Instant aInstant) {
        return Timestamp.from(aInstant);
    }
}

