/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.swing.component;

import java.awt.Component;
import java.awt.Container;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CUtilComponentFinder {
    private CUtilComponentFinder() {
    }

    @Nullable
    public static Component findByName(@NotNull Component aRoot, @NotNull String aName) {
        String name = aRoot.getName();
        if (aName.equals(name)) {
            return aRoot;
        }
        if (aRoot instanceof Container) {
            Component[] components;
            Container container = (Container)aRoot;
            for (Component c : components = container.getComponents()) {
                Component result = CUtilComponentFinder.findByName(c, aName);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    public static boolean findAll(@NotNull Component aRoot, @NotNull Predicate<Component> aPredicate) {
        boolean stop = aPredicate.test(aRoot);
        if (stop) {
            return true;
        }
        if (aRoot instanceof Container) {
            Component[] components;
            Container container = (Container)aRoot;
            for (Component c : components = container.getComponents()) {
                stop = CUtilComponentFinder.findAll(c, aPredicate);
                if (!stop) continue;
                return true;
            }
        }
        return false;
    }
}

