/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.hash;

import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.util.CUtilByteArray;
import de.sillysky.nyssr.util.CUtilRandom;
import de.sillysky.nyssr.util.hash.CAbstractHash;
import de.sillysky.nyssr.util.hash.CUtilMd5;
import de.sillysky.nyssr.util.hash.EHashType;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class CHash
extends CAbstractHash {
    private static final ILogger LOG = CLoggerFactory.getLogger(CHash.class);
    private MessageDigest mMessageDigest = null;

    public CHash() {
        super(EHashType.EMPTY, null, "");
    }

    public CHash(String aAlgorithm, EHashType aType) throws NoSuchAlgorithmException {
        super(aType, null, aAlgorithm);
        if (aType != EHashType.EMPTY) {
            this.ensure();
        }
    }

    public CHash(String aAlgorithm, EHashType aType, byte[] aHash) throws NoSuchAlgorithmException {
        super(aType, aHash, aAlgorithm);
        if (aType != EHashType.EMPTY) {
            this.ensure();
        }
    }

    @NotNull
    public static String getString(byte[] aMd5) {
        return CUtilMd5.getString(aMd5);
    }

    @NotNull
    public static CHash random(int aSize) throws NoSuchAlgorithmException {
        byte[] data = CUtilByteArray.random(aSize);
        CHash hash = new CHash("SHA-384", EHashType.SHA384);
        hash.update(data, 0, data.length);
        hash.digest();
        return hash;
    }

    @Contract(pure=true)
    @NotNull
    public static @NotNull CHash @NotNull [] randomArray(int aSize, boolean aWithNullValues) throws NoSuchAlgorithmException {
        CHash[] arr = new CHash[aSize];
        for (int i = 0; i < aSize; ++i) {
            boolean b = CUtilRandom.getRandom().nextBoolean();
            if (!b && aWithNullValues) continue;
            arr[i] = CHash.random(20);
        }
        return arr;
    }

    @Override
    public void digest() {
        if (this.mMessageDigest != null) {
            this.storeDigest(this.mMessageDigest.digest());
        }
    }

    private void ensure() throws NoSuchAlgorithmException {
        if (this.mMessageDigest == null) {
            this.mMessageDigest = MessageDigest.getInstance(this.getAlgorithm());
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public byte[] getByteArrayWithHeader() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public int getDigestLength() {
        if (this.mMessageDigest != null) {
            return this.mMessageDigest.getDigestLength();
        }
        return 0;
    }

    @Override
    public void setDigest(byte[] aDigest) {
        if (aDigest == null) {
            LOG.error("IHash({}).setDigest: Can't process a digest of null.", this.getAlgorithm());
            return;
        }
        if (aDigest.length != this.getDigestLength()) {
            LOG.error("IHash({}).setDigest: Can't process a digest length of {}, need {} bytes.", this.getAlgorithm(), aDigest.length, this.getDigestLength());
            return;
        }
        this.storeDigest(aDigest);
    }

    @Override
    public void update(byte[] aData, int aPosition, int aLength) {
        if (this.mMessageDigest != null) {
            this.mMessageDigest.update(aData, aPosition, aLength);
        }
    }

    @Override
    public String valueToString() {
        return this.toString();
    }
}

