/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.files;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.util.CUtilString;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CUtilPath {
    private static final ILogger LOG = CLoggerFactory.getLogger(CUtilPath.class);
    private static final char SLASH = '/';
    private static final char DOT = '.';
    private static final char BACKSLASH = '\\';
    private static final Pattern STRIP_EXT = Pattern.compile("(?<=.)\\.[^.]+$");
    private static final String USER_DIR = System.getProperty("user.dir");

    private CUtilPath() {
    }

    @NotNull
    public static File changeExtension(@NotNull File aSource, @Nullable String aExtension) {
        File result;
        Path parent;
        String name = aSource.getName();
        int index = name.lastIndexOf(46);
        if (index >= 0) {
            name = name.substring(0, index);
        }
        if (aExtension != null && !aExtension.isEmpty()) {
            name = aExtension.charAt(0) != '.' ? name + '.' + aExtension : name + aExtension;
        }
        if ((parent = aSource.toPath().getParent()) == null) {
            result = new File(name);
        } else {
            Path path = parent.resolve(name);
            result = path.toFile();
        }
        return result;
    }

    @Nullable
    public static String getAbsolutePath(@NotNull String aDefaultBasePath, @Nullable String aFilePath) {
        String result = null;
        if (CUtilString.isValid(aFilePath)) {
            try {
                File file = Paths.get(aFilePath, new String[0]).isAbsolute() ? Paths.get(aFilePath, new String[0]).toFile() : Paths.get(aDefaultBasePath, aFilePath).toFile();
                result = file.getCanonicalPath();
            }
            catch (Exception e) {
                result = null;
            }
        }
        return result;
    }

    @Nullable
    public static String getAbsolutePath(@NotNull String aDefaultBasePath, @Nullable String aPath, @Nullable String aFileName) {
        String result = null;
        if (CUtilString.isValid(aFileName)) {
            try {
                File file = CUtilString.isValid(aPath) ? (Paths.get(aPath, new String[0]).isAbsolute() ? Paths.get(aPath, aFileName).toFile() : Paths.get(aDefaultBasePath, aPath, aFileName).toFile()) : Paths.get(aDefaultBasePath, aFileName).toFile();
                result = file.getCanonicalPath();
            }
            catch (Exception e) {
                result = null;
            }
        }
        return result;
    }

    @NotNull
    public static String getCurrentPath() {
        return USER_DIR;
    }

    @NotNull
    public static String getExtension(@Nullable String aPath) {
        if (CUtilString.isEmpty(aPath)) {
            return "";
        }
        String file = CUtilPath.stripPath(aPath);
        int pos = file.lastIndexOf(46);
        if (pos <= 0) {
            return "";
        }
        return file.substring(pos);
    }

    @NotNull
    public static String getExtensionWithoutDot(@Nullable String aPath) {
        if (CUtilString.isEmpty(aPath)) {
            return "";
        }
        String file = CUtilPath.stripPath(aPath);
        int pos = file.lastIndexOf(46);
        if (pos <= 0) {
            return "";
        }
        return file.substring(pos + 1);
    }

    @NotNull
    public static String getFileName(@NotNull String aPath) {
        return new File(aPath).getName();
    }

    @NotNull
    public static String getParentFileName(@NotNull String aPath) {
        String result = "";
        try {
            Path fileName;
            Path parent = Paths.get(aPath, new String[0]).getParent();
            if (parent != null && (fileName = parent.getFileName()) != null) {
                result = fileName.toString();
            }
        }
        catch (Exception aE) {
            result = "";
        }
        return result;
    }

    @Nullable
    public static String getParentPath(@Nullable String aPath) {
        Path p;
        if (CUtilString.isValid(aPath) && (p = Paths.get(aPath, new String[0]).getParent()) != null) {
            return p.toString();
        }
        return null;
    }

    public static String getPath(String aParentPath, String aFileName) {
        String path = CUtilPath.normalizeSlashesInPath(aParentPath);
        return Paths.get(path, aFileName).toString();
    }

    public static String getRelativePath(String aPathBase, String aToPath) {
        Path path = Paths.get(aPathBase, new String[0]);
        return CUtilPath.getRelativePath(path, aToPath);
    }

    public static String getRelativePath(Path aPathBase, String aToPath) {
        String result;
        try {
            Path p = aPathBase.relativize(new File(aToPath).toPath());
            result = p.toString();
        }
        catch (Exception e) {
            result = aToPath;
        }
        if (result != null && result.isEmpty()) {
            result = ".";
        }
        return result;
    }

    @NotNull
    public static String normalizeSlashesInPath(@NotNull String aPath) {
        String result = '/' != File.separatorChar ? aPath.replace('/', File.separatorChar) : aPath.replace('\\', File.separatorChar);
        return result;
    }

    @NotNull
    public static String normalizePath(@NotNull String aPath) {
        Path path = Paths.get(aPath, new String[0]);
        Path normalizedPath = path.normalize();
        return normalizedPath.toString();
    }

    @NotNull
    public static File removeExtension(@NotNull File aFile, @NotNull String aExtension, boolean aRename) throws CException {
        File result = aFile;
        String name = aFile.getName();
        if (name.endsWith(aExtension)) {
            int len = name.length() - aExtension.length();
            String newName = name.substring(0, len);
            Path newPath = Paths.get(aFile.getParent(), newName);
            result = newPath.toFile();
            if (aRename && aFile.exists()) {
                boolean renameTo;
                try {
                    renameTo = aFile.renameTo(result);
                }
                catch (Exception e) {
                    LOG.error("Error renaming file {} to {}.", aFile, result);
                    throw new CException(e);
                }
                if (!renameTo) {
                    throw new CException(2205).append("Unable to rename file.");
                }
            }
        }
        return result;
    }

    @NotNull
    public static String stripExtension(@NotNull String aFileName) {
        if (CUtilString.isEmpty(aFileName)) {
            return "";
        }
        return STRIP_EXT.matcher(aFileName).replaceAll("");
    }

    @NotNull
    public static String stripPath(@NotNull String aFileName) {
        if (CUtilString.isEmpty(aFileName)) {
            return "";
        }
        return aFileName.replaceAll(".*[\\\\/]|\\.[^.]*$\u200c\u200b", "");
    }

    @NotNull
    public static String stripPathAndExtension(@Nullable String aPath) {
        String result = "";
        if (CUtilString.isValid(aPath)) {
            result = CUtilPath.stripPath(aPath);
            result = CUtilPath.stripExtension(result);
        }
        return result;
    }

    public static String extractPath(@Nullable String aPath) {
        int pos2;
        if (CUtilString.isEmpty(aPath)) {
            return "";
        }
        int pos1 = aPath.lastIndexOf(47);
        int pos = Math.max(pos1, pos2 = aPath.lastIndexOf(92));
        if (pos < 0) {
            return "";
        }
        return aPath.substring(0, pos + 1);
    }

    @NotNull
    public static String extractFileNameExt(@Nullable String aPath) {
        int pos2;
        if (CUtilString.isEmpty(aPath)) {
            return "";
        }
        int pos1 = aPath.lastIndexOf(47);
        int pos = Math.max(pos1, pos2 = aPath.lastIndexOf(92));
        if (pos < 0) {
            return aPath;
        }
        return aPath.substring(pos + 1);
    }

    @NotNull
    public static String createPathString(boolean aPrefixSeparator, boolean aPostSeparator, Object ... aArgs) {
        StringBuilder sb = new StringBuilder(200);
        if (aPrefixSeparator) {
            sb.append(File.separator);
        }
        if (aArgs != null) {
            boolean once = true;
            for (Object o : aArgs) {
                if (o == null) continue;
                if (once) {
                    once = false;
                } else {
                    sb.append(File.separator);
                }
                sb.append(o);
            }
        }
        if (aPostSeparator) {
            sb.append(File.separator);
        }
        return sb.toString();
    }

    public static Path resolvePath(String aOptionalBaseDir, String aPath) {
        if (".".equals(aPath) || CUtilString.isEmpty(aPath)) {
            return Paths.get(aOptionalBaseDir, new String[0]);
        }
        if ("..".equals(aPath)) {
            return Paths.get(aOptionalBaseDir, new String[0]).getParent();
        }
        Path path = Paths.get(aPath, new String[0]);
        if (path.isAbsolute()) {
            return path;
        }
        return Paths.get(aOptionalBaseDir, new String[0]).resolve(aPath).toAbsolutePath();
    }

    @NotNull
    public static String ensureLastSlash(@Nullable String aPath) {
        if (CUtilString.isEmpty(aPath)) {
            return File.separator;
        }
        int length = aPath.length();
        Character lastChar = Character.valueOf(aPath.charAt(length - 1));
        if (lastChar.equals(Character.valueOf('/')) || lastChar.equals(Character.valueOf('\\'))) {
            return aPath + File.separator;
        }
        return aPath;
    }

    public static boolean isParent(@NotNull Path aPath, @NotNull Path aParent) {
        if (!CUtilPath.hasDotDot(aPath)) {
            for (Path path = aPath.getParent(); path != null; path = path.getParent()) {
                if (!path.equals(aParent)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasDotDot(@NotNull Path aPath) {
        return aPath.toString().contains("..");
    }

    public static List<Path> getListOfFiles(@NotNull Path aPath, @NotNull String aExtension) throws IOException {
        try (Stream<Path> files = Files.walk(Paths.get(aPath.toUri()), new FileVisitOption[0]);){
            List<Path> list = files.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.toString().endsWith(aExtension)).collect(Collectors.toList());
            return list;
        }
    }
}

