/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util;

import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.stringrecord.CStringRecord;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CUtilInteger {
    private static final ILogger LOG = CLoggerFactory.getLogger(CUtilInteger.class);
    private static final Pattern NUMBER_REGEX_PATTERN = Pattern.compile("^([+\\-])?\\d+$");

    private CUtilInteger() {
    }

    public static int fromObject(@Nullable Object aValue, int aDefault) {
        int result = aDefault;
        if (aValue != null) {
            if (aValue instanceof Float) {
                result = (int)((Float)aValue).floatValue();
            } else if (aValue instanceof Double) {
                result = (int)((Double)aValue).doubleValue();
            } else if (aValue instanceof Short) {
                result = ((Short)aValue).shortValue();
            } else if (aValue instanceof Integer) {
                result = (Integer)aValue;
            } else if (aValue instanceof Long) {
                long value = (Long)aValue;
                if (value > Integer.MAX_VALUE) {
                    return Integer.MAX_VALUE;
                }
                if (value < Integer.MIN_VALUE) {
                    return Integer.MIN_VALUE;
                }
                result = (int)value;
            } else if (aValue instanceof Byte) {
                result = ((Byte)aValue).byteValue();
            } else if (aValue instanceof Character) {
                result = ((Character)aValue).charValue();
            } else if (aValue instanceof String) {
                result = CUtilInteger.fromString((String)aValue, aDefault);
            } else {
                LOG.error("Can't convert object {} to int. Take default value {}", aValue, aDefault);
            }
        }
        return result;
    }

    public static int fromString(@Nullable String aValue) {
        return CUtilInteger.fromString(aValue, 0);
    }

    public static int fromString(@Nullable String aValue, int aDefault) {
        String value;
        if (aValue != null && NUMBER_REGEX_PATTERN.matcher(value = aValue.trim()).matches()) {
            try {
                long l = Long.parseLong(value);
                return CUtilInteger.fromObject(l, 0);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return aDefault;
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static String toString(int aValue) {
        return Integer.toString(aValue);
    }

    @NotNull
    public static String toString(int aValue, int aMaxLen) {
        String result = CUtilInteger.toString(aValue);
        result = CUtilString.shortenString(result, aMaxLen);
        return result;
    }

    @NotNull
    public static String toStringRecord(short aType, int aValue) {
        String key = Short.toString(aType);
        String value = CUtilInteger.toString(aValue);
        CStringRecord r = new CStringRecord(key, value);
        return r.getRecordString();
    }

    public static boolean isNumeric(@NotNull String aValue) {
        String value = aValue.trim();
        return NUMBER_REGEX_PATTERN.matcher(value).matches();
    }

    public static int fromStream(@NotNull DataInput aStream) throws IOException {
        return aStream.readInt();
    }

    public static void toStream(@NotNull DataOutput aStream, int aValue) throws IOException {
        aStream.writeInt(aValue);
    }
}

