/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.login.records;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordSessionGetPublicKey
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject("5f0ddb92-dc20-41a6-8103-87c5335b66ae");
    public static final String NAME = "SessionGetPublicKey";
    public static final String DESCRIPTION = "The central session manager sends public keys to all nodes for verifying session tokens.";
    public static final String SLOT_KEY_ALGORITHM = "1";
    public static final String SLOT_KEY_DATA = "2";
    public static final String[] NAMESPACES = new String[0];
    public static final boolean IS_NANO_SERVICE = false;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static String getKeyAlgorithm(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_KEY_ALGORITHM);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static byte[] getKeyData(@NotNull CRecord aRecord, byte[] aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_KEY_DATA);
        if (slot == null) {
            return aDefault;
        }
        return (byte[])slot.getValue();
    }

    public static void setKeyAlgorithm(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.STRING, aValue);
        aRecord.addSlot(SLOT_KEY_ALGORITHM, slot);
    }

    public static void setKeyData(@NotNull CRecord aRecord, byte[] aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.BYTE_ARRAY, aValue);
        aRecord.addSlot(SLOT_KEY_DATA, slot);
    }
}

