/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.test;

import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.impl.test.CRunningTest;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.signal.properties.IPropertySignal;
import de.sillysky.nyssr.signal.properties.IPropertySignalDispatcher;
import de.sillysky.nyssr.signal.properties.IPropertySignalDispatcherFactory;
import de.sillysky.nyssr.test.CTestConstants;
import de.sillysky.nyssr.test.IRunningTest;
import de.sillysky.nyssr.test.ITest;
import de.sillysky.nyssr.test.ITestRunner;
import de.sillysky.nyssr.util.CUtilString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public final class CTestRunner
implements ITestRunner {
    private static final ILogger LOG = CLoggerFactory.getLogger("test");
    private static final double NS_TO_MS = 1000000.0;
    private final Map<String, ITest> mTests = new HashMap<String, ITest>();
    private final Map<UUID, CRunningTest> mRunningTests = new HashMap<UUID, CRunningTest>();
    private IPropertySignalDispatcher mPropertySignalDispatcher;

    @Override
    public void abortTest(UUID aID) {
        CRunningTest run = this.findRunningTest(aID);
        CUtilCheck.checkNotNull(run, "No running Test found with ID %s", aID.toString());
        run.getTest().abortTest();
    }

    void activate(IPropertySignalDispatcherFactory aPropertySignalDispatcherFactory) {
        this.mPropertySignalDispatcher = aPropertySignalDispatcherFactory.createPropertySignalDispatcher("TestRunner");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deregisterTest(ITest aTest) {
        ITest removed;
        CUtilCheck.checkNotNull(aTest, "Test is null.", new Object[0]);
        String suite = aTest.getTestSuite();
        CUtilCheck.checkEmptyString(suite, "TestSuite is empty", new Object[0]);
        String name = aTest.getTestName();
        CUtilCheck.checkEmptyString(name, "TestName is empty", new Object[0]);
        String key = this.getTestKey(suite, name);
        Map<String, ITest> map = this.mTests;
        synchronized (map) {
            removed = this.mTests.remove(key);
        }
        if (removed != null) {
            LOG.debug("Test {}#{} deregistered", suite, name);
            IPropertySignal signal = this.mPropertySignalDispatcher.createSignal(CTestConstants.SIGNAL_TEST_REMOVED);
            this.testToSignal(signal, aTest);
            this.mPropertySignalDispatcher.signal(signal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CRunningTest findRunningTest(UUID aId) {
        Map<UUID, CRunningTest> map = this.mRunningTests;
        synchronized (map) {
            return this.mRunningTests.get(aId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ITest findTest(String aSuite, String aName) {
        String key = this.getTestKey(aSuite, aName);
        Map<String, ITest> map = this.mTests;
        synchronized (map) {
            return this.mTests.get(key);
        }
    }

    @Override
    public void finished(UUID aTestRunId, int aResultCode, long aLoopsProcessed, long aNanos) {
        CRunningTest run = this.removeTestRun(aTestRunId);
        if (run != null) {
            LOG.debug(CUtilString.LINE_CRLF);
            LOG.debug("Test {} ready", run.toString());
            LOG.debug("TimeInNanoseconds  = {}", aNanos);
            LOG.debug("TimeInMilliseconds = {}", (double)aNanos / 1000000.0);
            double timeInSec = (double)aNanos / 1.0E9;
            LOG.debug("TimeInSeconds      = {}", timeInSec);
            LOG.debug("loops              = {}", aLoopsProcessed);
            LOG.debug("ResultCode         = {}", aResultCode);
            LOG.debug("loops/second       = {}", (double)aLoopsProcessed / timeInSec);
            LOG.debug(CUtilString.LINE_CRLF);
        }
    }

    @Override
    public IPropertySignalDispatcher getPropertySignalDispatcher() {
        return this.mPropertySignalDispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<IRunningTest> getRunningTests() {
        Map<UUID, CRunningTest> map = this.mRunningTests;
        synchronized (map) {
            return new ArrayList<IRunningTest>(this.mRunningTests.values());
        }
    }

    private String getTestKey(String aTestSuite, String aTestName) {
        return aTestSuite + '#' + aTestName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ITest> getTests() {
        Map<String, ITest> map = this.mTests;
        synchronized (map) {
            return new ArrayList<ITest>(this.mTests.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerTest(ITest aTest) {
        CUtilCheck.checkNotNull(aTest, "Test is null.", new Object[0]);
        String suite = aTest.getTestSuite();
        CUtilCheck.checkEmptyString(suite, "TestSuite is empty", new Object[0]);
        String name = aTest.getTestName();
        CUtilCheck.checkEmptyString(name, "TestName is empty", new Object[0]);
        String key = this.getTestKey(suite, name);
        Map<String, ITest> map = this.mTests;
        synchronized (map) {
            this.mTests.put(key, aTest);
        }
        LOG.debug("Test {}#{} registered", suite, name);
        IPropertySignal signal = this.mPropertySignalDispatcher.createSignal(CTestConstants.SIGNAL_TEST_ADDED);
        this.testToSignal(signal, aTest);
        this.mPropertySignalDispatcher.signal(signal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CRunningTest removeTestRun(UUID aID) {
        CRunningTest r;
        Map<UUID, CRunningTest> map = this.mRunningTests;
        synchronized (map) {
            r = this.mRunningTests.remove(aID);
        }
        if (r != null) {
            IPropertySignal signal = this.mPropertySignalDispatcher.createSignal(CTestConstants.SIGNAL_TEST_RUN_REMOVED);
            this.testToSignal(signal, r);
            this.mPropertySignalDispatcher.signal(signal);
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startTest(String aTestSuite, String aTestName, long aLoopCount) throws Exception {
        CUtilCheck.checkEmptyString(aTestSuite, "TestSuite is empty.", new Object[0]);
        CUtilCheck.checkEmptyString(aTestName, "TestSuite is empty.", new Object[0]);
        ITest test = this.findTest(aTestSuite, aTestName);
        CUtilCheck.checkNotNull(test, "Test %s-%s not found.", aTestSuite, aTestName);
        CUtilCheck.checkTrue(aLoopCount > 0L, "Loopcount <= 0", new Object[0]);
        CRunningTest run = new CRunningTest(test, aLoopCount);
        Map<UUID, CRunningTest> map = this.mRunningTests;
        synchronized (map) {
            this.mRunningTests.put(run.getID(), run);
        }
        IPropertySignal signal = this.mPropertySignalDispatcher.createSignal(CTestConstants.SIGNAL_TEST_RUN_ADDED);
        this.testToSignal(signal, run);
        this.mPropertySignalDispatcher.signal(signal);
        LOG.debug("Run Test {}#{}.", aTestSuite, aTestName);
        test.startTest(run.getID(), this, aLoopCount);
    }

    private void testToSignal(IPropertySignal aSignal, IRunningTest aTest) {
        aSignal.set("runningID", aTest.getID());
        aSignal.set("loopsToPerform", aTest.getLoopCount());
        this.testToSignal(aSignal, aTest.getTest());
    }

    private void testToSignal(IPropertySignal aSignal, ITest aTest) {
        aSignal.set("testSuite", aTest.getTestSuite());
        aSignal.set("testName", aTest.getTestName());
        aSignal.set("testDesc", aTest.getTestDescription());
        aSignal.set("supportLoops", aTest.supportLoops());
    }
}

