/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.slot;

import de.sillysky.nyssr.address.CSegmentId;
import de.sillysky.nyssr.address.CUtilSegmentIdArray;
import de.sillysky.nyssr.json.CJsonArray;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISingleSlotTypeFactory;
import de.sillysky.nyssr.slot.ISlot;
import de.sillysky.nyssr.util.CUtilObjectArray;
import de.sillysky.nyssr.util.CUtilString;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CSlotSegmentIdArray
implements ISlot,
ISingleSlotTypeFactory {
    private final CSegmentId[] mValue;

    CSlotSegmentIdArray() {
        this.mValue = null;
    }

    private CSlotSegmentIdArray(CSegmentId @Nullable [] aValue) {
        this.mValue = CUtilSegmentIdArray.copy(aValue);
    }

    @NotNull
    private static CSlotSegmentIdArray fromObject(@Nullable Object aValue) {
        if (aValue instanceof CSegmentId[]) {
            return new CSlotSegmentIdArray((CSegmentId[])aValue);
        }
        if (aValue instanceof String) {
            return CSlotSegmentIdArray.fromString((String)aValue);
        }
        if (aValue instanceof List) {
            return CSlotSegmentIdArray.fromList((List)aValue);
        }
        return new CSlotSegmentIdArray();
    }

    @NotNull
    private static CSlotSegmentIdArray fromList(@NotNull List<?> aList) {
        CSegmentId[] array = CUtilSegmentIdArray.fromList(aList);
        return new CSlotSegmentIdArray(array);
    }

    @NotNull
    private static CSlotSegmentIdArray fromStream(@NotNull DataInput aStream) throws IOException {
        CSegmentId[] array = CUtilSegmentIdArray.fromStream(aStream);
        return new CSlotSegmentIdArray(array);
    }

    @NotNull
    private static CSlotSegmentIdArray fromString(@NotNull String aString) {
        CSegmentId[] array = CUtilSegmentIdArray.fromString(aString);
        return new CSlotSegmentIdArray(array);
    }

    @Override
    @Nullable
    public ISlot fromObject(@NotNull CSlotType aType, @Nullable Object aValue) {
        if (this.getType().equals(aType)) {
            return CSlotSegmentIdArray.fromObject(aValue);
        }
        return null;
    }

    @Override
    @Nullable
    public ISlot fromJson(@Nullable Object aValue, @NotNull Map<Integer, byte[]> aByteArrayStore) {
        if (aValue instanceof CJsonArray) {
            CJsonArray arr = (CJsonArray)aValue;
            CSegmentId[] values = new CSegmentId[arr.size()];
            int i = 0;
            for (Object child : arr.getChildren()) {
                if (child instanceof String && CUtilString.isValid((String)child)) {
                    values[i++] = CSegmentId.fromObject(child);
                    continue;
                }
                values[i++] = null;
            }
            return new CSlotSegmentIdArray(values);
        }
        return null;
    }

    @Override
    public boolean equals(@Nullable Object aObj) {
        if (this == aObj) {
            return true;
        }
        if (aObj == null) {
            return false;
        }
        if (this.getClass() != aObj.getClass()) {
            return false;
        }
        CSlotSegmentIdArray other = (CSlotSegmentIdArray)aObj;
        return CUtilSegmentIdArray.isArrayEqual(this.mValue, other.mValue);
    }

    @Override
    @NotNull
    public Class<?> getClassOfProducedObject() {
        return CSegmentId[].class;
    }

    @Override
    @NotNull
    public ISlot copy() {
        return new CSlotSegmentIdArray(this.mValue);
    }

    @Override
    @NotNull
    public CSlotType getType() {
        return CCommonSlotType.SEGMENT_ID_ARRAY;
    }

    @Override
    @Nullable
    public Object getValue() {
        return this.mValue;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.mValue);
    }

    @Override
    public boolean isContentEqualTo(@Nullable Object aValue) {
        if (this.mValue == aValue) {
            return true;
        }
        if (this.mValue != null && aValue != null && aValue instanceof CSegmentId[]) {
            CSegmentId[] bb = (CSegmentId[])aValue;
            return CUtilSegmentIdArray.isArrayEqual(this.mValue, bb);
        }
        return false;
    }

    @Override
    @Nullable
    public ISlot readSlot(@NotNull DataInput aStream, @NotNull CSlotType aType) throws IOException {
        if (this.getType().equals(aType)) {
            return CSlotSegmentIdArray.fromStream(aStream);
        }
        return null;
    }

    @Override
    public void toStream(@NotNull DataOutput aStream) throws IOException {
        CUtilSegmentIdArray.toStream(aStream, this.mValue);
    }

    @NotNull
    public String toString() {
        return CUtilObjectArray.toString((Object[])this.mValue, 1000);
    }

    @Override
    @NotNull
    public String valueToString() {
        return CUtilSegmentIdArray.toString(this.mValue);
    }

    @Override
    @Nullable
    public Object toJson(@NotNull Map<Integer, byte[]> aBinaries) {
        if (this.mValue != null && this.mValue.length > 0) {
            CJsonArray arr = new CJsonArray();
            for (CSegmentId value : this.mValue) {
                arr.add(value == null ? "" : value.valueToString());
            }
            return arr;
        }
        return null;
    }
}

