/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.signal.properties;

import de.sillysky.nyssr.impl.signal.properties.CPropertySignal;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.signal.properties.IPropertySignal;
import de.sillysky.nyssr.signal.properties.IPropertySignalDispatcher;
import de.sillysky.nyssr.signal.properties.IPropertySignalListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public final class CPropertySignalDispatcher
implements IPropertySignalDispatcher {
    private static final ILogger LOG = CLoggerFactory.getLogger(CPropertySignalDispatcher.class);
    private static final int DEFAULT_COUNT = 20;
    private final Map<UUID, Set<IPropertySignalListener>> mListeners = new HashMap<UUID, Set<IPropertySignalListener>>(20);
    private final Map<UUID, IPropertySignal> mLastSignals = new HashMap<UUID, IPropertySignal>(20);
    private final String mName;
    private boolean mVerbose = false;
    private int mCounter = 0;
    private int mOffset = 0;
    private Map<UUID, String> mDebugNames = null;
    private Map<Integer, String> mOffsetStrings = null;

    CPropertySignalDispatcher(String aName) {
        this.mName = aName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(UUID aID, IPropertySignalListener aListener, boolean aTriggerLast) {
        Map<UUID, Object> map = this.mListeners;
        synchronized (map) {
            Set<IPropertySignalListener> set = this.mListeners.get(aID);
            if (set == null) {
                set = new HashSet<IPropertySignalListener>();
                this.mListeners.put(aID, set);
                LOG.debug("Listener added, id={}, class={}.", aID, aListener.getClass().getName());
            }
            set.add(aListener);
        }
        if (aTriggerLast) {
            map = this.mLastSignals;
            synchronized (map) {
                IPropertySignal last = this.mLastSignals.get(aID);
                if (last != null) {
                    try {
                        aListener.incomingSignal(last);
                    }
                    catch (Exception e) {
                        LOG.error(e, "Exception on triggering Signal {}: ", last);
                    }
                }
            }
        }
    }

    private String createOffsetString(int offset) {
        if (offset > 0) {
            char[] array = new char[offset];
            Arrays.fill(array, ' ');
            return new String(array);
        }
        return "";
    }

    @Override
    public IPropertySignal createSignal(UUID aID) {
        return new CPropertySignal(aID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dismiss() {
        Map<UUID, Object> map = this.mListeners;
        synchronized (map) {
            this.mListeners.clear();
        }
        map = this.mLastSignals;
        synchronized (map) {
            this.mLastSignals.clear();
        }
    }

    @Override
    public String getName() {
        return this.mName;
    }

    private String getOffsetString(int aOffset) {
        String result = this.mOffsetStrings.get(aOffset);
        if (result == null) {
            result = this.createOffsetString(aOffset);
            this.mOffsetStrings.put(aOffset, result);
        }
        return result;
    }

    @Override
    public void registerName(UUID aID, String aName) {
        if (this.mDebugNames == null) {
            this.mDebugNames = new HashMap<UUID, String>();
        }
        this.mDebugNames.put(aID, aName);
    }

    private void remove(UUID aId, Set<IPropertySignalListener> aSet, IPropertySignalListener aListener) {
        boolean removed;
        if (aSet != null && (removed = aSet.remove(aListener))) {
            LOG.debug("Listener removed, id={}, class={}.", aId, aListener.getClass().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(IPropertySignalListener aListener) {
        Map<UUID, Set<IPropertySignalListener>> map = this.mListeners;
        synchronized (map) {
            for (Map.Entry<UUID, Set<IPropertySignalListener>> s : this.mListeners.entrySet()) {
                this.remove(s.getKey(), s.getValue(), aListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(UUID aID, IPropertySignalListener aListener) {
        Map<UUID, Set<IPropertySignalListener>> map = this.mListeners;
        synchronized (map) {
            Set<IPropertySignalListener> set = this.mListeners.get(aID);
            this.remove(aID, set, aListener);
        }
    }

    @Override
    public void setVerbose(boolean aVerbose) {
        this.mVerbose = aVerbose;
        if (this.mVerbose) {
            this.mDebugNames = new HashMap<UUID, String>();
            this.mOffsetStrings = new HashMap<Integer, String>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void signal(IPropertySignal aSignal) {
        if (aSignal != null) {
            aSignal.setSource(this);
            Map<UUID, Object> map = this.mLastSignals;
            synchronized (map) {
                this.mLastSignals.put(aSignal.getSignalID(), aSignal);
            }
            map = this.mListeners;
            synchronized (map) {
                Set<IPropertySignalListener> set = this.mListeners.get(aSignal.getSignalID());
                if (set != null) {
                    for (IPropertySignalListener l : set) {
                        try {
                            if (this.mVerbose) {
                                String s = this.getOffsetString(this.mOffset);
                                int counter = ++this.mCounter;
                                LOG.trace("{}-->SIGNAL {}, class={} {}", s, counter, l.getClass().getSimpleName(), aSignal.toString());
                                this.mOffset += 2;
                                l.incomingSignal(aSignal);
                                this.mOffset -= 2;
                                LOG.trace("{}<--SIGNAL {}", s, counter);
                                continue;
                            }
                            l.incomingSignal(aSignal);
                        }
                        catch (Exception e) {
                            LOG.error(e, "Exception on triggering Signal {}: ", aSignal);
                            if (!this.mVerbose) continue;
                            this.mOffset -= 2;
                        }
                    }
                }
            }
        }
    }

    @Override
    public void signal(UUID aID) {
        CPropertySignal signal = new CPropertySignal(aID);
        this.signal(signal);
    }
}

