/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.namespace.creator;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.common.CWellKnownNID;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.kernel.configuration.IKernelConfiguration;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.namespace.INamespaceFactory;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.service.IServiceStarter;
import de.sillysky.nyssr.util.CUtilString;
import java.nio.file.Path;
import java.util.prefs.Preferences;
import org.jetbrains.annotations.NotNull;

public class CPackageImplNamespaceCreator
implements IServiceStarter {
    private static final ILogger LOG = CLoggerFactory.getLogger(CPackageImplNamespaceCreator.class);

    @Override
    public void getDependencies(@NotNull IServiceDependencyList aDependencyList) {
        aDependencyList.add(IKernelConfiguration.class);
        aDependencyList.add(INamespaceFactory.class);
    }

    @Override
    public void start(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        IKernelConfiguration kernelConfiguration = aServiceRegistry.getServiceOrThrow(IKernelConfiguration.class);
        INamespaceFactory namespaceFactory = aServiceRegistry.getServiceOrThrow(INamespaceFactory.class);
        namespaceFactory.createAndRegisterNamespace(CWellKnownNID.SYSTEM, "SYSTEM");
        Path configDir = kernelConfiguration.getConfigurationPath();
        CUtilCheck.checkNotNull(configDir, "Missing ConfigDir.", new Object[0]);
        Preferences prefs = kernelConfiguration.getPreferences("namespace");
        String namespaceList = prefs.get("namespaces", "");
        namespaceList = namespaceList.trim();
        if (CUtilString.isValid(namespaceList)) {
            LOG.info("No Namespaces found to create on startup.");
        } else {
            String[] namespaces;
            LOG.info("Namespaces to create on startup: {}", namespaceList);
            for (String nsName : namespaces = namespaceList.split(",")) {
                if (!CUtilString.isValid(nsName = nsName.trim())) continue;
                IId nid = CIdFactory.fromObject(nsName);
                try {
                    namespaceFactory.createAndRegisterNamespace(nid, "NamespaceOnStartup");
                }
                catch (CException e) {
                    LOG.error(e, "Error creating namespace {}", nsName);
                }
            }
        }
    }

    @Override
    public void stop(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
    }
}

