/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.configuration.requester;

import de.sillysky.nyssr.util.CUtilInteger;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.tcp.CTcpConnection;
import de.sillysky.nyssr.util.tcp.ITcpOwner;
import de.sillysky.nyssr.util.time.stopwatch.CStopWatch;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;

public class CConfigurationRequester
implements ITcpOwner {
    private static final int INPUT_BUFFER_SIZE = 20000;
    private final String mLock = "";
    private String mHost;
    private int mPort;
    private CTcpConnection mConnection;
    private String mNodeIdString;
    private String mResult = "";

    @NotNull
    public String requestConfiguration(@NotNull String aNodeIdString, @NotNull String aDestination) {
        this.mNodeIdString = aNodeIdString;
        if (this.parse(aDestination)) {
            this.internalRequestConfiguration();
        }
        return this.mResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void internalRequestConfiguration() {
        CStopWatch watch = new CStopWatch().start();
        if (!this.connect()) return;
        String string = "";
        synchronized ("") {
            try {
                "".wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.out.println(watch.getAccumulatedTime() / 1000000L + " ms");
            return;
        }
    }

    private boolean parse(@NotNull String aDestination) {
        this.mHost = null;
        this.mPort = 28346;
        String[] split = aDestination.split(":");
        if (split.length >= 1) {
            this.mHost = split[0].trim();
        }
        if (split.length >= 2) {
            this.mPort = CUtilInteger.fromObject(split[1], 28346);
        }
        if (CUtilString.isEmpty(this.mHost)) {
            System.err.println("Fetch remote configuration: Argument host missing");
            return false;
        }
        return true;
    }

    private boolean connect() {
        System.out.println("Start TcpClient on " + this.mHost + " Port " + this.mPort);
        try {
            InetSocketAddress sockAddress = new InetSocketAddress(this.mHost, this.mPort);
            Socket socket = new Socket();
            socket.setReuseAddress(true);
            socket.connect(sockAddress, 2000);
            socket.setTcpNoDelay(true);
            this.mConnection = new CTcpConnection(this, 20000, socket);
            System.out.println("TCP Client started on " + this.mHost + " Port " + this.mPort);
            this.mConnection.send(this.mNodeIdString.getBytes(StandardCharsets.UTF_8));
            return true;
        }
        catch (Exception e) {
            System.err.println("Unable to connect " + this.mHost + ":" + this.mPort + ", (failOnFirstConnect=true, -> fail)");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyInput(Object aDataProvider, byte[] aBytes) {
        this.mResult = new String(aBytes, StandardCharsets.UTF_8);
        this.mConnection.close();
        String string = "";
        synchronized ("") {
            "".notify();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void notifyOpened(@NotNull CTcpConnection aConnection) {
    }

    @Override
    public void notifyClosed(@NotNull CTcpConnection aConnection) {
    }

    @Override
    @NotNull
    public String getName() {
        return "ConfigurationRequester";
    }
}

