/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.configuration.files.records;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordGetConfigFileList
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject("a4bc3b2b-38a8-47dc-a064-6a40d0d1550c");
    public static final String NAME = "GetConfigFileList";
    public static final String DESCRIPTION = "Get the list of configuration files loaded at startup.";
    public static final String SLOT_LIST = "1";
    public static final String[] NAMESPACES = new String[]{"SYSTEM"};
    public static final boolean IS_NANO_SERVICE = true;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static String[] getList(@NotNull CRecord aRecord, String[] aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_LIST);
        if (slot == null) {
            return aDefault;
        }
        return (String[])slot.getValue();
    }

    public static void setList(@NotNull CRecord aRecord, String[] aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.STRING_ARRAY, aValue);
        aRecord.addSlot(SLOT_LIST, slot);
    }
}

