/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.configuration.files.records;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordCreateConfigFile
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject("13178373-4d13-4997-a5eb-c4429f8c565a");
    public static final String NAME = "CreateConfigFile";
    public static final String DESCRIPTION = "Create a new configuration file and with the given content.";
    public static final String SLOT_CONTENT = "2";
    public static final String SLOT_FILENAME = "1";
    public static final String SLOT_PATH = "10";
    public static final String[] NAMESPACES = new String[]{"SYSTEM"};
    public static final boolean IS_NANO_SERVICE = true;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static String getContent(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_CONTENT);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static String getFilename(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_FILENAME);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static String getPath(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_PATH);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static void setContent(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.STRING, aValue);
        aRecord.addSlot(SLOT_CONTENT, slot);
    }

    public static void setFilename(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.STRING, aValue);
        aRecord.addSlot(SLOT_FILENAME, slot);
    }

    public static void setPath(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.STRING, aValue);
        aRecord.addSlot(SLOT_PATH, slot);
    }
}

