/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.address;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CNodeId;
import de.sillysky.nyssr.address.CSegmentId;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.id.EIdType;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.util.CUtilString;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CNamespaceAddress
implements Comparable<CNamespaceAddress> {
    private static final char DOT = '.';
    @NotNull
    private final IId mNID;
    @NotNull
    private final CNodeAddress mNodeAddress;

    public CNamespaceAddress() {
        this.mNID = IId.INVALID;
        this.mNodeAddress = new CNodeAddress(CNodeId.getEmpty());
    }

    public CNamespaceAddress(@NotNull IId aNID) {
        CUtilCheck.checkNotNull(aNID, "NID is null", new Object[0]);
        this.mNID = aNID;
        this.mNodeAddress = CNodeAddress.EMPTY;
    }

    public CNamespaceAddress(@NotNull IId aNID, @NotNull CNodeAddress aNodeAddress) {
        CUtilCheck.checkNotNull(aNID, "NID is null", new Object[0]);
        CUtilCheck.checkNotNull(aNodeAddress, "NID is null", new Object[0]);
        this.mNID = aNID;
        this.mNodeAddress = aNodeAddress;
    }

    public CNamespaceAddress(@NotNull IId aNID, @NotNull CNodeId aNodeId, @NotNull CSegmentId aSegmentId) {
        CUtilCheck.checkNotNull(aNID, "NID is null", new Object[0]);
        this.mNID = aNID;
        this.mNodeAddress = new CNodeAddress(aNodeId, aSegmentId);
    }

    @Nullable
    public static CNamespaceAddress fromStream(@NotNull DataInput aStream) throws IOException {
        boolean valid = aStream.readBoolean();
        if (valid) {
            IId nid = CIdFactory.fromStream(aStream, true);
            CNodeAddress nodeAddress = CNodeAddress.fromStream(aStream);
            if (nid != null && nodeAddress != null) {
                return new CNamespaceAddress(nid, nodeAddress);
            }
        }
        return null;
    }

    @NotNull
    public static CNamespaceAddress random() {
        return new CNamespaceAddress(CIdFactory.randomOfType(EIdType.INT), CNodeAddress.random());
    }

    @NotNull
    public static CNamespaceAddress fromString(@Nullable String aString) {
        if (CUtilString.isEmpty(aString)) {
            return new CNamespaceAddress();
        }
        String[] split = aString.split("[.]");
        IId nid = IId.INVALID;
        CNodeId nodeId = CNodeId.getEmpty();
        CSegmentId segmentId = CSegmentId.EMPTY;
        if (split.length >= 1) {
            nid = CIdFactory.fromObject(split[0]);
        }
        if (split.length >= 2) {
            nodeId = CNodeId.fromObject(split[1]);
        }
        if (split.length >= 3) {
            segmentId = new CSegmentId(split[2]);
        }
        return new CNamespaceAddress(nid, nodeId, segmentId);
    }

    @NotNull
    public IId getNID() {
        return this.mNID;
    }

    public boolean equals(Object aOther) {
        if (this == aOther) {
            return true;
        }
        if (aOther == null || this.getClass() != aOther.getClass()) {
            return false;
        }
        CNamespaceAddress that = (CNamespaceAddress)aOther;
        return this.mNID.equals(that.mNID) && this.mNodeAddress.equals(that.mNodeAddress);
    }

    public int hashCode() {
        return Objects.hash(this.mNID, this.mNodeAddress);
    }

    @NotNull
    public CNodeId getNodeId() {
        return this.mNodeAddress.getNodeId();
    }

    @NotNull
    public CSegmentId getSegmentId() {
        return this.mNodeAddress.getSegmentId();
    }

    public boolean match(@Nullable IId aNID, @Nullable CNodeAddress aNodeAddress) {
        return this.matchNid(aNID) && this.mNodeAddress.equals(aNodeAddress);
    }

    public boolean matchNid(@Nullable IId aNID) {
        return this.mNID.equals(aNID);
    }

    @NotNull
    public String toNamespaceString() {
        return this.valueToString();
    }

    public String toString() {
        return this.toNamespaceString();
    }

    public static void toStream(@NotNull DataOutput aStream, @Nullable CNamespaceAddress aValue) throws IOException {
        if (aValue == null) {
            aStream.writeBoolean(false);
        } else {
            aStream.writeBoolean(true);
            CIdFactory.toStream(aStream, aValue.mNID);
            CNodeAddress.toStream(aStream, aValue.mNodeAddress);
        }
    }

    @NotNull
    public String valueToString() {
        return this.mNID.valueToString() + '.' + this.mNodeAddress.valueToString();
    }

    @Override
    public int compareTo(@NotNull CNamespaceAddress aOther) {
        int result = this.mNID.compareTo(aOther.getNID());
        if (result == 0) {
            result = this.mNodeAddress.compareTo(aOther.getNodeAddress());
        }
        return result;
    }

    @NotNull
    public CNodeAddress getNodeAddress() {
        return this.mNodeAddress;
    }
}

