/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.session.manager;

import de.sillysky.nyssr.database.CH2Table;
import de.sillysky.nyssr.log.ILogger;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

class CTableUserRoleRelation
extends CH2Table {
    protected CTableUserRoleRelation(@NotNull Connection aConnection, @NotNull ILogger aLogger, @NotNull String aName) {
        super(aConnection, aLogger, aName);
        this.createTable();
    }

    private void createTable() {
        if (!this.existTable("X051_USER_ROLE")) {
            String sql = "CREATE TABLE IF NOT EXISTS X051_USER_ROLE(X051_USER_ID VARCHAR not null,X051_ROLE_ID VARCHAR not null,PRIMARY KEY (X051_USER_ID,X051_ROLE_ID),FOREIGN KEY (X051_USER_ID) REFERENCES X050_USER(X050_USER_ID),FOREIGN KEY (X051_ROLE_ID) REFERENCES X053_ROLE(X053_ROLE_ID))";
            this.executeUpdate("CREATE TABLE IF NOT EXISTS X051_USER_ROLE(X051_USER_ID VARCHAR not null,X051_ROLE_ID VARCHAR not null,PRIMARY KEY (X051_USER_ID,X051_ROLE_ID),FOREIGN KEY (X051_USER_ID) REFERENCES X050_USER(X050_USER_ID),FOREIGN KEY (X051_ROLE_ID) REFERENCES X053_ROLE(X053_ROLE_ID))", "createTable", null);
            this.addUserToRole("admin", "Administrator");
            this.addUserToRole("admin", "UserManager");
            this.addUserToRole("admin", "UserViewer");
            this.addUserToRole("admin", "UserVerifier");
            this.addUserToRole("guest", "Guests");
            this.addUserToRole("guest", "UserViewer");
            this.addUserToRole("guest", "UserVerifier");
        }
    }

    public void addUserToRole(@NotNull String aUserId, @NotNull String aRoleId) {
        String sql = "INSERT INTO X051_USER_ROLE (X051_USER_ID,X051_ROLE_ID) VALUES (?, ?)";
        this.executeUpdate("INSERT INTO X051_USER_ROLE (X051_USER_ID,X051_ROLE_ID) VALUES (?, ?)", "insert", statement -> {
            statement.setString(1, aUserId);
            statement.setString(2, aRoleId);
        });
    }

    public void removeUserFromRole(@NotNull String aUserId, @NotNull String aRoleId) {
        String sql = "DELETE FROM X051_USER_ROLE WHERE X051_USER_ID=? AND X051_ROLE_ID=?";
        this.executeUpdate("DELETE FROM X051_USER_ROLE WHERE X051_USER_ID=? AND X051_ROLE_ID=?", "delete", statement -> {
            statement.setString(1, aUserId);
            statement.setString(2, aRoleId);
        });
    }

    Collection<String> getRolesForUser(@NotNull String aUserId) {
        ArrayList<String> list = new ArrayList<String>();
        String sql = "SELECT X051_ROLE_ID FROM X051_USER_ROLE WHERE X051_USER_ID=?";
        this.executeQuery("SELECT X051_ROLE_ID FROM X051_USER_ROLE WHERE X051_USER_ID=?", "getRolesFor", st -> st.setString(1, aUserId), rs -> {
            while (rs.next()) {
                list.add(rs.getString(1));
            }
            return list;
        });
        return list;
    }

    void removeUser(@NotNull String aUserId) {
        String sql = "DELETE FROM X051_USER_ROLE WHERE X051_USER_ID=?";
        this.executeUpdate("DELETE FROM X051_USER_ROLE WHERE X051_USER_ID=?", "deleteUser", statement -> statement.setString(1, aUserId));
    }

    void deleteAll() {
        String sql = "DELETE FROM X051_USER_ROLE";
        this.executeUpdate("DELETE FROM X051_USER_ROLE", "delete", null);
    }

    public void removeRole(@NotNull String aRoleId) {
        String sql = "DELETE FROM X051_USER_ROLE WHERE X051_ROLE_ID=?";
        this.executeUpdate("DELETE FROM X051_USER_ROLE WHERE X051_ROLE_ID=?", "removeRole", statement -> statement.setString(1, aRoleId));
    }
}

