/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.link.collector;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.impl.link.collector.CLink;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class CLinkList {
    private final Set<CLink> mLinks = new HashSet<CLink>();

    CLinkList() {
    }

    void add(@NotNull CLink aLink) {
        this.mLinks.add(aLink);
    }

    boolean remove(@NotNull CLink aLink) {
        return this.mLinks.remove(aLink);
    }

    int size() {
        return this.mLinks.size();
    }

    public void removeNode(@NotNull CNodeAddress aNode) {
        this.mLinks.removeIf(link -> link.hasNode(aNode));
    }

    public void syncNode(@NotNull CNodeAddress aNode, @NotNull CNodeAddress[] aRemoteNodes, int[] aCosts) {
        ArrayList<CNodeAddress> newDirectLinks = new ArrayList<CNodeAddress>(Arrays.asList(aRemoteNodes));
        Iterator<CLink> it = this.mLinks.iterator();
        while (it.hasNext()) {
            int index;
            CLink link = it.next();
            CNodeAddress node1 = link.getNode1();
            CNodeAddress node2 = link.getNode2();
            if (aNode.equals((Object)node1)) {
                index = this.getArrayIndex(node2, aRemoteNodes);
                if (index >= 0) {
                    if (aCosts != null) {
                        link.updateCosts(aCosts[index]);
                    }
                } else {
                    it.remove();
                }
                newDirectLinks.remove(aRemoteNodes[index]);
                continue;
            }
            if (!aNode.equals((Object)node2)) continue;
            index = this.getArrayIndex(node1, aRemoteNodes);
            if (index >= 0) {
                if (aCosts != null) {
                    link.updateCosts(aCosts[index]);
                }
            } else {
                it.remove();
            }
            newDirectLinks.remove(aRemoteNodes[index]);
        }
        for (CNodeAddress node2 : newDirectLinks) {
            if (aCosts != null) {
                int index = this.getArrayIndex(node2, aRemoteNodes);
                if (index >= 0) {
                    this.add(new CLink(aNode, node2, aCosts[index]));
                    continue;
                }
                this.add(new CLink(aNode, node2));
                continue;
            }
            this.add(new CLink(aNode, node2));
        }
    }

    private int getArrayIndex(@NotNull CNodeAddress aNode, @NotNull CNodeAddress[] aNodes) {
        int i = 0;
        for (CNodeAddress node : aNodes) {
            if (aNode.equals((Object)node)) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

