/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.app.factory.collector.records;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISlot;
import de.sillysky.nyssr.util.properties.CStringProperties;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public final class CRecordLaunchApplication
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject((Object)"d0140763-3cb9-4bd0-8c5f-1562c6e50216");
    public static final String NAME = "LaunchApplication";
    public static final String DESCRIPTION = "Create and launch an application instance.";
    public static final String SLOT_APPLICATION_ID = "1";
    public static final String SLOT_APP_INSTANCE_ID = "10";
    public static final String SLOT_INSTANCE_ADDRESS = "11";
    public static final String SLOT_PROPERTIES = "4";
    public static final String SLOT_REMOTE_SKIN_CLIENT_NODE = "2";
    public static final String SLOT_REMOTE_SKIN_TARGET = "3";
    public static final String[] NAMESPACES = new String[0];
    public static final boolean IS_NANO_SERVICE = false;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static UUID getApplicationId(@NotNull CRecord aRecord, UUID aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_APPLICATION_ID);
        if (slot == null) {
            return aDefault;
        }
        return (UUID)slot.getValue();
    }

    public static UUID getAppInstanceId(@NotNull CRecord aRecord, UUID aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_APP_INSTANCE_ID);
        if (slot == null) {
            return aDefault;
        }
        return (UUID)slot.getValue();
    }

    public static CTargetAddress getInstanceAddress(@NotNull CRecord aRecord, CTargetAddress aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_INSTANCE_ADDRESS);
        if (slot == null) {
            return aDefault;
        }
        return (CTargetAddress)slot.getValue();
    }

    public static CStringProperties getProperties(@NotNull CRecord aRecord, CStringProperties aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_PROPERTIES);
        if (slot == null) {
            return aDefault;
        }
        return (CStringProperties)slot.getValue();
    }

    public static CNodeAddress getRemoteSkinClientNode(@NotNull CRecord aRecord, CNodeAddress aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_REMOTE_SKIN_CLIENT_NODE);
        if (slot == null) {
            return aDefault;
        }
        return (CNodeAddress)slot.getValue();
    }

    public static CTargetAddress getRemoteSkinTarget(@NotNull CRecord aRecord, CTargetAddress aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_REMOTE_SKIN_TARGET);
        if (slot == null) {
            return aDefault;
        }
        return (CTargetAddress)slot.getValue();
    }

    public static void setApplicationId(@NotNull CRecord aRecord, UUID aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.UUID, (Object)aValue);
        aRecord.addSlot(SLOT_APPLICATION_ID, slot);
    }

    public static void setAppInstanceId(@NotNull CRecord aRecord, UUID aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.UUID, (Object)aValue);
        aRecord.addSlot(SLOT_APP_INSTANCE_ID, slot);
    }

    public static void setInstanceAddress(@NotNull CRecord aRecord, CTargetAddress aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.TARGET_ADDRESS, (Object)aValue);
        aRecord.addSlot(SLOT_INSTANCE_ADDRESS, slot);
    }

    public static void setProperties(@NotNull CRecord aRecord, CStringProperties aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING_PROPERTIES, (Object)aValue);
        aRecord.addSlot(SLOT_PROPERTIES, slot);
    }

    public static void setRemoteSkinClientNode(@NotNull CRecord aRecord, CNodeAddress aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.NODE_ADDRESS, (Object)aValue);
        aRecord.addSlot(SLOT_REMOTE_SKIN_CLIENT_NODE, slot);
    }

    public static void setRemoteSkinTarget(@NotNull CRecord aRecord, CTargetAddress aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.TARGET_ADDRESS, (Object)aValue);
        aRecord.addSlot(SLOT_REMOTE_SKIN_TARGET, slot);
    }
}

