/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.web.dialog.editright;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.web.dialog.editright.CConstants;
import de.sillysky.nyssr.json.CUtilJson;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.remoteskin.web.dialog.records.CRecordWebDismissDialog;
import de.sillysky.nyssr.remoteskin.web.protocol.CWebApi;
import de.sillysky.nyssr.remoteskin.web.protocol.CWebDialogApi;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebNotifyClick1;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebNotifyClick2;
import de.sillysky.nyssr.session.CConstantsSession;
import de.sillysky.nyssr.session.api.CRight;
import de.sillysky.nyssr.session.api.records.CRecordUserDbGetRightRecord;
import de.sillysky.nyssr.session.api.records.CRecordUserDbUpdateRight;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.properties.CStringProperties;
import org.jetbrains.annotations.NotNull;

class C00304EditRight
extends CTarget {
    private final byte[] mSessionToken;
    private final CTargetAddress mClientTargetAddress;
    private final CTargetAddress mOwnerTargetAddress;
    private final String mRightId;
    private CWebApi mWebApi;
    private CWebDialogApi mWebDialogApi;
    private static final String ID_INDEX_MODAL = "rs_30cb3f8d-cefd-40c5-81b8-7791895c7b95";
    private static final String ID_00304_MODAL = "id_00304_modal";
    private static final String ID_00304_CANCEL = "id_00304_cancel";
    private static final String ID_00304_SAVE = "id_00304_save";
    private static final String ID_00304_DESCRIPTION = "id_00304_description";
    private static final String ID_00304_RIGHT_ID = "id_00304_right_id";
    private static final String[] WIDGETS = new String[]{"id_00304_cancel", "id_00304_save"};
    private CTargetAddress mUserDbAddress;
    private CRight mRight;

    public C00304EditRight(byte[] aSessionToken, @NotNull CTargetAddress aClientTargetAddress, @NotNull CTargetAddress aOwnerTargetAddress, @NotNull String aRightId) {
        this.mSessionToken = aSessionToken;
        this.mClientTargetAddress = aClientTargetAddress;
        this.mOwnerTargetAddress = aOwnerTargetAddress;
        this.mRightId = aRightId;
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordWebDismissDialog.ID, this::asyncWebDismissDialog);
        this.addMessageHandler(CRecordWebNotifyClick1.ID, this::asyncWebNotifyClick1);
        this.addMessageHandler(CRecordWebNotifyClick2.ID, this::asyncWebNotifyClick2);
        this.addMessageHandler(CRecordUserDbGetRightRecord.ID, this::asyncGetRightRecord);
        this.addMessageHandler(CRecordUserDbUpdateRight.ID, this::asyncUserDbUpdateRight);
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.mWebApi = new CWebApi((ITarget)this, this.mClientTargetAddress);
        this.mWebDialogApi = new CWebDialogApi((ITarget)this, this.mClientTargetAddress);
        this.sendGetRightData(this.mRightId);
        this.mWebApi.registerWidgets(WIDGETS);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncWebDismissDialog(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.finish(3);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncWebNotifyClick1(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CStringProperties values = CRecordWebNotifyClick1.getValues((CRecord)aRecord, null);
        if (values != null) {
            String description = values.get(ID_00304_DESCRIPTION, "");
            this.sendSetRightData(this.mRightId, description);
        } else {
            this.finish(1);
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncWebNotifyClick2(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.finish(2);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncGetRightRecord(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            this.mUserDbAddress = aEnvelope.getSender();
            if (aEnvelope.getResult().isSuccess()) {
                String id = CRecordUserDbGetRightRecord.getRightId((CRecord)aRecord, (String)"");
                String description = CRecordUserDbGetRightRecord.getDescription((CRecord)aRecord, (String)"");
                this.mRight = new CRight(id, description, false);
                this.showDialog();
            } else {
                this.finish(1);
            }
            return true;
        }
        return false;
    }

    private boolean asyncUserDbUpdateRight(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            this.mUserDbAddress = aEnvelope.getSender();
            int resultCode = aEnvelope.getResultCode();
            if (resultCode == 0) {
                this.finish(0);
            } else {
                this.finish(1);
            }
            return true;
        }
        return false;
    }

    private void showDialog() throws CException {
        String main = CUtilJson.loadJson(((Object)((Object)this)).getClass(), (String)"/html/00304_edit_right.html");
        this.mWebApi.removeElement(ID_00304_MODAL);
        this.mWebApi.setInnerHtml(ID_INDEX_MODAL, main);
        this.mWebApi.setValue(ID_00304_RIGHT_ID, this.mRightId);
        String description = this.mRight.getDescription();
        if (CUtilString.isValid((String)description)) {
            this.mWebApi.setValue(ID_00304_DESCRIPTION, description);
        }
        this.mWebApi.showModal(ID_00304_MODAL);
        this.mWebApi.addClickListener1(ID_00304_SAVE, new String[]{ID_00304_RIGHT_ID, ID_00304_DESCRIPTION});
        this.mWebApi.addClickListener2(new String[]{ID_00304_CANCEL});
    }

    private void sendGetRightData(@NotNull String aId) throws CException {
        CRecord record = CRecordUserDbGetRightRecord.create();
        CRecordUserDbGetRightRecord.setRightId((CRecord)record, (String)aId);
        this.sendMessageToSessionManager(record);
    }

    private void sendMessageToSessionManager(@NotNull CRecord aRecord) throws CException {
        CEnvelope env = this.mUserDbAddress != null ? CEnvelope.forSingleTarget((CTargetAddress)this.mUserDbAddress) : CEnvelope.forMicroService((IId)CConstantsSession.MICRO_SERVICE_ID);
        env.setSessionToken(this.mSessionToken);
        this.sendRequest(env, aRecord);
    }

    private void sendSetRightData(@NotNull String aRightId, @NotNull String aDescription) throws CException {
        CRecord record = CRecordUserDbUpdateRight.create();
        CRecordUserDbUpdateRight.setRightId((CRecord)record, (String)aRightId);
        CRecordUserDbUpdateRight.setDescription((CRecord)record, (String)aDescription);
        this.sendMessageToSessionManager(record);
    }

    private void finish(int aReason) throws CException {
        this.mWebApi.removeElement(ID_00304_MODAL);
        CStringProperties sp = new CStringProperties();
        sp.put("rightId", this.mRightId);
        this.mWebDialogApi.notifyDismissed(this.mOwnerTargetAddress, CConstants.MICRO_SERVICE_ID, aReason, sp);
        this.mWebApi.deregisterWidgetOwner();
        this.deregisterTarget();
    }
}

