/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.network.index.records;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordNetworkIndexNotifyAvailable
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject((Object)"6d564b3e-7b57-44f7-86e3-c12b044827b1");
    public static final String NAME = "NetworkIndexNotifyAvailable";
    public static final String DESCRIPTION = "Notification that a network index is available.";
    public static final String SLOT_ADDRESS = "2";
    public static final String SLOT_AVAILABLE = "1";
    public static final String[] NAMESPACES = new String[]{"SYSTEM"};
    public static final boolean IS_NANO_SERVICE = true;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static CTargetAddress getAddress(@NotNull CRecord aRecord, CTargetAddress aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_ADDRESS);
        if (slot == null) {
            return aDefault;
        }
        return (CTargetAddress)slot.getValue();
    }

    public static boolean getAvailable(@NotNull CRecord aRecord, boolean aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_AVAILABLE);
        if (slot == null) {
            return aDefault;
        }
        return (Boolean)slot.getValue();
    }

    public static void setAddress(@NotNull CRecord aRecord, CTargetAddress aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.TARGET_ADDRESS, (Object)aValue);
        aRecord.addSlot(SLOT_ADDRESS, slot);
    }

    public static void setAvailable(@NotNull CRecord aRecord, boolean aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.BOOLEAN, (Object)aValue);
        aRecord.addSlot(SLOT_AVAILABLE, slot);
    }
}

