/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.web.dialog.editpreferences;

import de.sillysky.nyssr.address.CNodeId;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.configuration.files.records.CRecordAddPreferenceNode;
import de.sillysky.nyssr.configuration.files.records.CRecordDeletePreference;
import de.sillysky.nyssr.configuration.files.records.CRecordDeletePreferenceNode;
import de.sillysky.nyssr.configuration.files.records.CRecordGetPreferenceList;
import de.sillysky.nyssr.configuration.files.records.CRecordSetPreference;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.common.CWellKnownNID;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.impl.web.dialog.editpreferences.CConstants;
import de.sillysky.nyssr.impl.web.dialog.editpreferences.CPreferenceNode;
import de.sillysky.nyssr.impl.web.dialog.editpreferences.CPreferenceTree;
import de.sillysky.nyssr.impl.web.dialog.editpreferences.CPreferenceTreeBuilder;
import de.sillysky.nyssr.impl.web.dialog.editpreferences.CPreferenceValue;
import de.sillysky.nyssr.impl.web.dialog.editpreferences.IPreferenceItem;
import de.sillysky.nyssr.json.CUtilJson;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.remoteskin.web.protocol.CAbstractWebDialog;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebNotifyClick1;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.properties.CStringProperties;
import de.sillysky.nyssr.util.string.builder.CStringBuilder;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

class C00404EditPreferences
extends CAbstractWebDialog {
    private static final IId MICRO_SERVICE_YES_NO = CIdFactory.fromObject((Object)"NY_WebDialogYesNo_00001");
    private static final IId MICRO_SERVICE_ENTER_TEXT = CIdFactory.fromObject((Object)"NY_WebDialogEnterText_00002");
    private final CNodeId mNodeId;
    private static final String ID_00404_MODAL = "id_00404_modal";
    private static final String ID_00404_TREE = "id_00404_tree";
    private static final String ID_00404_ALERT = "id_00404_alert";
    private static final String ID_00404_MY_MODALS = "id_00404_my_modals";
    private static final String ID_00404_DISMISS = "id_00404_dismiss";
    private static final String ID_00404_SAVE = "id_00404_save";
    private static final String ID_00404_DELETE_KEY = "id_00404_delete_key";
    private static final String ID_00404_DELETE_NODE = "id_00404_delete_node";
    private static final String ID_00404_NEW_KEY = "id_00404_new_key";
    private static final String ID_00404_NEW_NODE = "id_00404_new_node";
    private static final String ID_00404_DESC = "id_00404_desc";
    private static final String ID_00404_KEY = "id_00404_key";
    private static final String ID_00404_VALUE = "id_00404_value";
    private static final String ID_CSS = "id_00404_css";
    private static final String ID_SCRIPT = "id_00404_script";
    private static final String[] WIDGETS = new String[]{"id_00404_dismiss", "id_00404_tree"};
    private boolean mDialogShown = false;
    private CPreferenceTree mTree;
    private IPreferenceItem mCurrentItem;
    private String mCurrentId = "";

    public C00404EditPreferences(byte[] aSessionToken, @NotNull CTargetAddress aClientTargetAddress, @NotNull CTargetAddress aOwnerTargetAddress, @NotNull String aParentWidgetId, @NotNull CNodeId aNodeId) {
        super(aSessionToken, aClientTargetAddress, aOwnerTargetAddress, aParentWidgetId, CConstants.MICRO_SERVICE_ID);
        this.mNodeId = aNodeId;
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordWebNotifyClick1.ID, this::asyncWebNotifyClick1);
        this.addMessageHandler(CRecordGetPreferenceList.ID, this::asyncGetPreferenceList);
        this.addMessageHandler(CRecordSetPreference.ID, this::asyncPreferenceRequests);
        this.addMessageHandler(CRecordDeletePreference.ID, this::asyncPreferenceRequests);
        this.addMessageHandler(CRecordAddPreferenceNode.ID, this::asyncPreferenceRequests);
        this.addMessageHandler(CRecordDeletePreferenceNode.ID, this::asyncPreferenceRequests);
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        String css = CUtilJson.loadJson(((Object)((Object)this)).getClass(), (String)"/html/00404.css");
        this.getWebApi().addCss(ID_CSS, css);
        this.sendGetPreferenceList();
        this.getWebApi().registerWidgets(WIDGETS);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncWebNotifyClick1(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        String id = CRecordWebNotifyClick1.getId((CRecord)aRecord, null);
        CStringProperties values = CRecordWebNotifyClick1.getValues((CRecord)aRecord, null);
        if (ID_00404_TREE.equals(id)) {
            if (values != null) {
                String itemId = values.get(ID_00404_TREE, "");
                this.setCurrentItem(this.mTree.getById(itemId));
                if (this.mCurrentItem instanceof CPreferenceNode) {
                    this.showNodeData((CPreferenceNode)this.mCurrentItem);
                } else if (this.mCurrentItem instanceof CPreferenceValue) {
                    this.showKeyValueData((CPreferenceValue)this.mCurrentItem);
                }
            }
        } else if (ID_00404_SAVE.equals(id)) {
            if (values != null) {
                String key = values.get(ID_00404_KEY, "");
                String value = values.get(ID_00404_VALUE, "");
                this.sendSetPreference(false, key, value);
            }
        } else if (ID_00404_DELETE_KEY.equals(id) && values != null) {
            String key = values.get(ID_00404_KEY, "");
            this.sendDeletePreference(key);
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncGetPreferenceList(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            if (aEnvelope.getResult().isSuccess()) {
                String[] nodePaths = CRecordGetPreferenceList.getNodes((CRecord)aRecord, null);
                CStringProperties preferences = CRecordGetPreferenceList.getKeyValuePairs((CRecord)aRecord, null);
                this.mTree = CPreferenceTreeBuilder.buildPreferenceTreeFromNodes(nodePaths);
                CPreferenceTreeBuilder.addKeyValuePairs(this.mTree, preferences);
                if (!this.mDialogShown) {
                    this.showDialog();
                } else {
                    this.updateList();
                }
            } else {
                this.showResult(aEnvelope);
            }
            return true;
        }
        return false;
    }

    private boolean asyncPreferenceRequests(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            if (aEnvelope.getResultCode() == 0) {
                this.sendGetPreferenceList();
            }
            this.showResult(aEnvelope);
            return true;
        }
        return false;
    }

    private void sendSetPreference(boolean aIsNewKeyValuePair, @NotNull String aKey, @NotNull String aValue) throws CException {
        if (this.mCurrentItem != null) {
            IPreferenceItem item = this.mCurrentItem instanceof CPreferenceNode ? this.mCurrentItem : this.mCurrentItem.getParent();
            CEnvelope env = CEnvelope.forRemoteNanoService((IId)CWellKnownNID.SYSTEM, (CNodeId)this.mNodeId);
            env.setSessionToken(this.getSessionToken());
            CRecord record = CRecordSetPreference.create();
            String keyPath = item.getPath() + "/" + aKey;
            if (!aIsNewKeyValuePair && !CUtilString.equals((String)this.mCurrentItem.getKey(), (String)aKey)) {
                this.sendDeletePreference(this.mCurrentItem.getKey());
                this.setCurrentItem(this.mCurrentItem.getParent());
            }
            CRecordSetPreference.setKey((CRecord)record, (String)keyPath);
            this.mCurrentId = CPreferenceTree.createKeyValueId(keyPath);
            CRecordSetPreference.setValue((CRecord)record, (String)aValue);
            this.sendRequest(env, record);
        }
    }

    private void sendAddNode(@NotNull String aNodeName) throws CException {
        if (this.mCurrentItem != null) {
            CEnvelope env = CEnvelope.forRemoteNanoService((IId)CWellKnownNID.SYSTEM, (CNodeId)this.mNodeId);
            env.setSessionToken(this.getSessionToken());
            CRecord record = CRecordAddPreferenceNode.create();
            String currentPath = this.mCurrentItem.getPath();
            String keyPath = currentPath.isEmpty() ? aNodeName : currentPath + "/" + aNodeName;
            CRecordAddPreferenceNode.setNodeName((CRecord)record, (String)keyPath);
            this.mCurrentId = CPreferenceTree.createNodeId(keyPath);
            this.sendRequest(env, record);
        }
    }

    private void sendDeletePreference(@NotNull String aKey) throws CException {
        if (this.mCurrentItem != null) {
            CEnvelope env = CEnvelope.forRemoteNanoService((IId)CWellKnownNID.SYSTEM, (CNodeId)this.mNodeId);
            env.setSessionToken(this.getSessionToken());
            CRecord record = CRecordDeletePreference.create();
            CRecordDeletePreference.setKey((CRecord)record, (String)(this.mCurrentItem.getPath() + "/" + aKey));
            this.sendRequest(env, record);
            this.setCurrentItem(this.mCurrentItem.getParent());
        }
    }

    private void showNodeData(@NotNull CPreferenceNode aNode) throws CException {
        String text = CUtilJson.loadJson(((Object)((Object)this)).getClass(), (String)"/html/00404_node.html");
        String path = aNode.getPath();
        text = CUtilString.replaceFirstOccurrence((String)text, (String)"{PATH}", (String)path);
        this.getWebApi().setInnerHtml(ID_00404_DESC, text);
        this.getWebApi().addClickListener2(new String[]{ID_00404_NEW_KEY, ID_00404_DELETE_NODE, ID_00404_NEW_NODE});
        CStringProperties sp = new CStringProperties();
        sp.put("display", path.isEmpty() ? "none" : "block");
        this.getWebApi().setStylesForElements("#id_00404_delete_node", sp);
    }

    private void showKeyValueData(@NotNull CPreferenceValue aItem) throws CException {
        String text = CUtilJson.loadJson(((Object)((Object)this)).getClass(), (String)"/html/00404_key.html");
        text = CUtilString.replaceFirstOccurrence((String)text, (String)"{KEY}", (String)aItem.getKey());
        text = CUtilString.replaceFirstOccurrence((String)text, (String)"{PATH}", (String)aItem.getPath());
        text = CUtilString.replaceFirstOccurrence((String)text, (String)"{VALUE}", (String)aItem.getValue());
        this.getWebApi().setInnerHtml(ID_00404_DESC, text);
        this.getWebApi().addClickListener1(ID_00404_SAVE, new String[]{ID_00404_KEY, ID_00404_VALUE});
        this.getWebApi().addClickListener1(ID_00404_DELETE_KEY, new String[]{ID_00404_KEY});
        this.getWebApi().addClickListener2(new String[]{ID_00404_NEW_KEY});
    }

    private void showResult(@NotNull CEnvelope aEnvelope) throws CException {
        int code = aEnvelope.getResultCode();
        String message = aEnvelope.getResultText();
        message = code == 0 ? "Done." : message.replaceAll("\n", "<br>");
        this.showAlert(message);
    }

    public void notifyClick2(@NotNull String aWidgetId) throws CException {
        switch (aWidgetId) {
            case "id_00404_dismiss": {
                this.finish(2);
                break;
            }
            case "id_00404_new_key": {
                this.sendEnterText("Please enter the name of the key:", ID_00404_NEW_KEY, "KeyName");
                break;
            }
            case "id_00404_new_node": {
                this.sendEnterText("Please enter the name of the node:", ID_00404_NEW_NODE, "NodeName");
                break;
            }
            case "id_00404_delete_node": {
                this.sendAskDelete();
            }
        }
    }

    private void showDialog() throws CException {
        String main = CUtilJson.loadJson(((Object)((Object)this)).getClass(), (String)"/html/00404_main.html");
        this.getWebApi().removeElement(ID_00404_MODAL);
        main = CUtilString.replaceAllOccurrences((String)main, (String)"{nodeid}", (String)this.mNodeId.toString());
        if (this.mTree != null) {
            CStringBuilder sb = new CStringBuilder("\n");
            this.addChild(sb, this.mTree.getRoot());
            main = CUtilString.replaceFirstOccurrence((String)main, (String)"{tree}", (String)sb.toString());
        }
        this.getWebApi().setInnerHtml(this.getParentWidgetId(), main);
        this.getWebApi().showModal(ID_00404_MODAL);
        this.getWebApi().addClickListener2(new String[]{ID_00404_DISMISS});
        this.addJs();
        this.mDialogShown = true;
    }

    private void addChild(@NotNull CStringBuilder aSb, @NotNull CPreferenceNode aPreferenceNode) {
        aSb.appendTab().append("<li>").append("<span id='").append(aPreferenceNode.getId()).append("' class='cl_00404_pnode cl_00404_caret'>").append(aPreferenceNode.getNodeName()).append("</span>").newLine().inc();
        aSb.appendTab().append("<ul class='cl_00404_nested'>").newLine().inc();
        for (Map.Entry<String, CPreferenceNode> entry : aPreferenceNode.getChildNodes().entrySet()) {
            this.addChild(aSb, entry.getValue());
        }
        for (Map.Entry<String, IPreferenceItem> entry : aPreferenceNode.getKeyValues().entrySet()) {
            String value = this.shortenValueString((CPreferenceValue)entry.getValue());
            aSb.appendTab().append("<li id='").append(((CPreferenceValue)entry.getValue()).getId()).append("' class='cl_00404_item'>").append(entry.getKey()).append(" = ").append(value).append("</li>").newLine();
        }
        aSb.dec().appendTab().append("</ul>").newLine();
        aSb.dec().appendTab().append("</li>").newLine();
    }

    @NotNull
    private String shortenValueString(CPreferenceValue aValue) {
        String s;
        String value = "";
        if (aValue != null && (s = aValue.getValue()) != null) {
            value = s.substring(0, Math.min(70, s.length()));
            if (s.length() > 70) {
                value = value.concat("...");
            }
        }
        return value;
    }

    private void updateList() throws CException {
        if (this.mTree != null) {
            CStringBuilder sb = new CStringBuilder("\n");
            this.addChild(sb, this.mTree.getRoot());
            this.getWebApi().setInnerHtml(ID_00404_TREE, sb.toString());
        }
        this.addJs();
    }

    public void notifySubDialogFinished(@NotNull IId aMicroServiceId, @NotNull CStringProperties aResults) throws CException {
        String text;
        if (MICRO_SERVICE_YES_NO.equals((Object)aMicroServiceId)) {
            String id;
            IPreferenceItem item;
            String action = aResults.get("action");
            String result = aResults.get("result");
            if ("deleteNode".equals(action) && "yes".equals(result) && (item = this.mTree.getById(id = aResults.get("id"))) instanceof CPreferenceNode) {
                this.sendDeleteNode(item.getPath());
            }
        } else if (MICRO_SERVICE_ENTER_TEXT.equals((Object)aMicroServiceId) && CUtilString.isValid((String)(text = aResults.get("result")))) {
            String action = aResults.get("action");
            if (ID_00404_NEW_NODE.equals(action)) {
                this.sendAddNode(text);
            } else if (ID_00404_NEW_KEY.equals(action)) {
                this.sendSetPreference(true, text, "");
            }
        }
    }

    private void sendDeleteNode(@NotNull String aPath) throws CException {
        CEnvelope env = CEnvelope.forRemoteNanoService((IId)CWellKnownNID.SYSTEM, (CNodeId)this.mNodeId);
        env.setSessionToken(this.getSessionToken());
        CRecord record = CRecordDeletePreferenceNode.create();
        CRecordDeletePreferenceNode.setNodePath((CRecord)record, (String)aPath);
        this.setCurrentItem(this.mCurrentItem.getParent());
        this.sendRequest(env, record);
    }

    private void sendGetPreferenceList() throws CException {
        CEnvelope env = CEnvelope.forRemoteNanoService((IId)CWellKnownNID.SYSTEM, (CNodeId)this.mNodeId);
        env.setSessionToken(this.getSessionToken());
        CRecord record = CRecordGetPreferenceList.create();
        this.sendRequest(env, record);
    }

    protected void clearBeforeDismiss() throws CException {
        this.getWebApi().removeCss(ID_CSS);
        this.getWebApi().removeScript(ID_SCRIPT);
        this.getWebApi().removeElement(ID_00404_MODAL);
    }

    private void showAlert(@NotNull String aMessage) throws CException {
        String alert = CUtilJson.loadJson(((Object)((Object)this)).getClass(), (String)"/html/00404_alert.html");
        alert = CUtilString.replaceFirstOccurrence((String)alert, (String)"{message}", (String)aMessage);
        this.getWebApi().setInnerHtml(ID_00404_ALERT, alert);
    }

    private void sendEnterText(@NotNull String aMessage, @NotNull String aAction, @NotNull String aLabel) throws CException {
        CStringProperties sp = new CStringProperties();
        sp.put("message", aMessage);
        sp.put("pattern", "[a-zA-Z\\-_\\.]*");
        sp.put("placeholder", aLabel);
        sp.put("aria-label", aLabel);
        sp.put("action", aAction);
        this.getWebDialogApi().showWebDialog(MICRO_SERVICE_ENTER_TEXT, this.getSessionToken(), ID_00404_MY_MODALS, sp);
    }

    private void sendAskDelete() throws CException {
        if (this.mCurrentItem instanceof CPreferenceNode) {
            CStringProperties sp = new CStringProperties();
            sp.put("message", "Do you want to delete the node " + this.mCurrentItem.getPath() + "?");
            sp.put("action", "deleteNode");
            sp.put("id", this.mCurrentItem.getId());
            this.getWebDialogApi().showWebDialog(MICRO_SERVICE_YES_NO, this.getSessionToken(), ID_00404_MY_MODALS, sp);
        }
    }

    private void addJs() throws CException {
        String js = CUtilJson.loadJson(((Object)((Object)this)).getClass(), (String)"/html/00404.js");
        js = CUtilString.replaceFirstOccurrence((String)js, (String)"{CURRENTNODEID}", (String)(this.mCurrentId.isEmpty() ? "null" : "\"" + this.mCurrentId + "\""));
        this.getWebApi().addScript(ID_SCRIPT, js, null);
    }

    private void setCurrentItem(IPreferenceItem aItem) {
        this.mCurrentItem = aItem;
        this.mCurrentId = aItem == null ? "" : aItem.getId();
    }
}

