/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.session.manager;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.impl.session.manager.ILocalService;
import de.sillysky.nyssr.session.api.CRightList;
import de.sillysky.nyssr.session.verifier.CSessionData;
import de.sillysky.nyssr.util.CUtilByteArray;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.CUtilStringArray;
import de.sillysky.nyssr.util.CUtilUuid;
import de.sillysky.nyssr.util.time.CUtilZonedDateTime;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

class CSessionEntry {
    private final CSessionData mData;
    private byte[] mLongToken;
    private final ILocalService mLocalService;

    @NotNull
    static CSessionEntry fromStream(@NotNull ILocalService aLocalService, @NotNull DataInputStream aStream) throws IOException, CException {
        byte[] shortToken = CUtilByteArray.fromStream((DataInput)aStream);
        byte[] longToken = CUtilByteArray.fromStream((DataInput)aStream);
        String userId = CUtilString.fromStream((DataInput)aStream);
        @NotNull String[] rights = CUtilStringArray.fromStream((DataInput)aStream);
        ZonedDateTime timestamp = CUtilZonedDateTime.fromStream((DataInput)aStream);
        if (shortToken == null || longToken == null || userId == null || timestamp == null) {
            throw new CException(6);
        }
        return new CSessionEntry(aLocalService, shortToken, longToken, userId, rights, timestamp);
    }

    CSessionEntry(@NotNull ILocalService aLocalService, @NotNull String aUserId, @NotNull CRightList aRights) {
        this.mData = new CSessionData(CUtilUuid.toByteArray((UUID)CUtilUuid.random()), aUserId, aRights.toRightIdArray(), ZonedDateTime.now());
        this.mLocalService = aLocalService;
        this.mLongToken = null;
    }

    CSessionEntry(@NotNull ILocalService aLocalService, byte[] aShortToken, byte[] aLongToken, @NotNull String aUserId, @NotNull CRightList aRights, @NotNull ZonedDateTime aTimeStamp) {
        this.mData = new CSessionData(aShortToken, aUserId, aRights.toRightIdArray(), aTimeStamp);
        this.mLocalService = aLocalService;
        this.mLongToken = aLongToken;
    }

    CSessionEntry(@NotNull ILocalService aLocalService, byte[] aShortToken, byte[] aLongToken, @NotNull String aUserId, @NotNull String[] aRights, @NotNull ZonedDateTime aTimeStamp) {
        this.mData = new CSessionData(aShortToken, aUserId, aRights, aTimeStamp);
        this.mLocalService = aLocalService;
        this.mLongToken = aLongToken;
    }

    byte[] getShortToken() {
        return this.mData.getShortToken();
    }

    byte[] getLongToken() {
        return this.mLongToken;
    }

    String getUserId() {
        return this.mData.getUserId();
    }

    boolean hasRight(@NotNull String aRight) {
        String[] rightIds;
        for (String rightId : rightIds = this.mData.getRightIds()) {
            if (!rightId.equals(aRight)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.mData.getUserId();
    }

    public boolean equals(Object aO) {
        if (this == aO) {
            return true;
        }
        if (aO == null || this.getClass() != aO.getClass()) {
            return false;
        }
        CSessionEntry that = (CSessionEntry)aO;
        return CUtilByteArray.isEqual((byte[])this.mLongToken, (byte[])that.mLongToken);
    }

    public int hashCode() {
        return CUtilByteArray.hashcode((byte[])this.mLongToken);
    }

    ZonedDateTime getTimeStamp() {
        return this.mData.getTimeStamp();
    }

    void notifyActivity() {
        this.mData.setTimeStamp(ZonedDateTime.now());
    }

    boolean isExpired() {
        return this.mData.getTimeStamp().isBefore(ZonedDateTime.now().minusMinutes(this.mLocalService.getTimeoutInMinutes()));
    }

    public void toStream(@NotNull DataOutputStream aStream) throws IOException {
        CUtilByteArray.toStream((DataOutput)aStream, (byte[])this.mData.getShortToken());
        CUtilByteArray.toStream((DataOutput)aStream, (byte[])this.mLongToken);
        CUtilString.toStream((DataOutput)aStream, (String)this.mData.getUserId());
        CUtilStringArray.toStream((DataOutput)aStream, (String[])this.mData.getRightIds());
        CUtilZonedDateTime.toStream((DataOutput)aStream, (ZonedDateTime)this.mData.getTimeStamp());
    }

    public void setLongToken(byte[] aLongToken) {
        this.mLongToken = aLongToken;
    }

    public CSessionData getSessionData() {
        return this.mData;
    }
}

