/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.software.updater.local;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.impl.software.updater.local.CSerialJobMachine;
import de.sillysky.nyssr.login.records.CRecordSessionValidate;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.ITargetRegistry;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.util.CUtilByteArray;
import de.sillysky.nyssr.util.job.serial.ISerialJobQueueEntry;
import org.jetbrains.annotations.NotNull;

class CJobCheckSession
extends CTarget
implements ISerialJobQueueEntry {
    private static final IId MICRO_SERVICE_SESSION = CIdFactory.fromObject((Object)"ccf168c1-f18b-4229-85f9-24461a19ee6a");
    private final ITargetRegistry mTargetRegistry;
    private final CSerialJobMachine mParent;

    CJobCheckSession(@NotNull ITargetRegistry aTargetRegistry, @NotNull CSerialJobMachine aParent) {
        this.mTargetRegistry = aTargetRegistry;
        this.mParent = aParent;
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordSessionValidate.ID, this::asyncAnswerValidate);
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.validate(this.mParent.getSessionToken());
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncAnswerValidate(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            int resultCode = aEnvelope.getResultCode();
            if (resultCode != 0) {
                this.mParent.finish(5108, "Unknown session token");
                return true;
            }
            byte[] token = aEnvelope.getSessionToken();
            if (!CUtilByteArray.isEqual((byte[])this.mParent.getSessionToken(), (byte[])token)) {
                this.mParent.finish(15, "wrong token");
                return true;
            }
            String[] rights = CRecordSessionValidate.getRights((CRecord)aRecord, null);
            this.mParent.setRights(rights);
            this.mParent.jobFinished(this);
            return true;
        }
        return false;
    }

    @NotNull
    public String getId() {
        return "CheckSession";
    }

    public void stop() {
        this.deregisterTarget();
    }

    public void start() throws CException {
        this.mTargetRegistry.registerTarget((ITarget)this);
    }

    private void validate(byte[] aSessionToken) throws CException {
        CEnvelope env = CEnvelope.forMicroService((IId)MICRO_SERVICE_SESSION);
        env.setPacketBuilderSequence("MA");
        env.setSessionToken(aSessionToken);
        CRecord record = CRecordSessionValidate.create();
        this.sendRequest(env, record);
    }
}

