/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.swing.icon;

import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.util.stream.CUtilStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.swing.ImageIcon;

public final class CIconHelper {
    private static final ILogger LOG = CLoggerFactory.getLogger(CIconHelper.class);

    private CIconHelper() {
    }

    public static ImageIcon loadFromJar(Class<?> aClassFromJar, String aPath, String aDescription) {
        URL imgURL = aClassFromJar.getClassLoader().getResource(aPath);
        if (imgURL != null) {
            return new ImageIcon(imgURL, aDescription);
        }
        LOG.error("Couldn't find file: " + aPath);
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] loadBytesFromJar(Class<?> aClassFromJar, String aPath) {
        try (InputStream is = aClassFromJar.getResourceAsStream(aPath);){
            byte[] byArray = CUtilStream.readByteArrayFully(is);
            return byArray;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

