/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.json;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.util.stream.CUtilStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;

public class CUtilJson {
    private static final ILogger LOG = CLoggerFactory.getLogger(CUtilJson.class);

    private CUtilJson() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static String loadJson(@NotNull Class<?> aParent, @NotNull String aPath) throws CException {
        try (InputStream stream = aParent.getResourceAsStream(aPath);){
            String json;
            byte[] bytes = CUtilStream.readByteArrayFully(stream);
            String string = json = new String(bytes, StandardCharsets.UTF_8);
            return string;
        }
        catch (Exception e) {
            LOG.error("Error on loading JSON file {}", aPath);
            throw new CException(2).append(e);
        }
    }
}

