/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.timer.target;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.common.CWellKnownTID;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.notification.records.CRecordNotifyNamespaceDeregistered;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.helper.CRecordHelper;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.registry.ITargetRegistry;
import de.sillysky.nyssr.target.registry.records.CRecordNotifyTargetDeregistered;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.timer.ITimerManager;
import org.jetbrains.annotations.NotNull;

public final class CTargetForTimerManager
extends CTarget
implements IService {
    private static final String FILTER = "nid=SYSTEM";
    private static final ILogger LOG = CLoggerFactory.getLogger(CTargetForTimerManager.class);
    private ITimerManager mManager;

    static void addDependencies(IServiceDependencyList aDependencyList) {
        aDependencyList.add(ITargetRegistry.class, FILTER);
        aDependencyList.add(ITimerManager.class);
    }

    @Override
    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws CException {
        this.mManager = aServiceRegistry.getService(ITimerManager.class);
        LOG.debug("Activate {} {}", this.getClass().getSimpleName(), System.identityHashCode(this));
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordNotifyNamespaceDeregistered.ID, this::asyncNotifyNamespaceDeregistered);
        this.addMessageHandler(CRecordNotifyTargetDeregistered.ID, this::asyncNotifyTargetDeregistered);
        ITargetRegistry tr = aServiceRegistry.getService(ITargetRegistry.class, FILTER);
        assert (tr != null);
        tr.registerTarget(this, CWellKnownTID.TIMER_SERVICE);
    }

    private boolean asyncNotifyNamespaceDeregistered(CEnvelope aEnvelope, CRecord aRecord) {
        IId nid = CRecordNotifyNamespaceDeregistered.getNamespace(aRecord, null);
        this.mManager.notifyNamespaceDeregistered(nid);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncNotifyTargetDeregistered(CEnvelope aEnvelope, CRecord aRecord) {
        CTargetAddress address = CRecordNotifyTargetDeregistered.getAddress(aRecord, null);
        this.mManager.notifyTargetDeregistered(address);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncStartTarget(CEnvelope aEnvelope, CRecord aRecord) throws CException {
        CRecordHelper.addObserver(CRecordNotifyNamespaceDeregistered.class, this, false);
        CRecordHelper.addObserver(CRecordNotifyTargetDeregistered.class, this, false);
        aEnvelope.setResultSuccess();
        return true;
    }

    @Override
    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        this.deregisterTarget();
    }
}

