/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.stream.hook;

import de.sillysky.nyssr.network.stream.hook.IStreamMonitor;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

final class CMonitorFilterInputStream
extends FilterInputStream {
    private final Set<IStreamMonitor> mMonitors;

    CMonitorFilterInputStream(InputStream aStream, Set<IStreamMonitor> aMonitors) {
        super(aStream);
        this.mMonitors = aMonitors;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        int val = super.read();
        for (IStreamMonitor monitor : this.mMonitors) {
            monitor.rx(new byte[]{(byte)val}, 0, 1);
        }
        return val;
    }

    @Override
    public int read(byte @NotNull [] aByte) throws IOException {
        int read = super.read(aByte);
        if (read > 0) {
            for (IStreamMonitor monitor : this.mMonitors) {
                monitor.rx(aByte, 0, read);
            }
        }
        return read;
    }

    @Override
    public int read(byte @NotNull [] aByte, int aOffset, int aLength) throws IOException {
        int read = super.read(aByte, aOffset, aLength);
        if (read > 0) {
            for (IStreamMonitor monitor : this.mMonitors) {
                monitor.rx(aByte, aOffset, read);
            }
        }
        return read;
    }

    @Override
    public long skip(long n) throws IOException {
        if (n > 0L) {
            byte[] data = new byte[(int)(n % Integer.MAX_VALUE)];
            return this.read(data);
        }
        return super.skip(n);
    }
}

