/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.packet.factory.registry;

import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.network.packets.EPacketType;
import de.sillysky.nyssr.network.packets.IPacketFactory;
import de.sillysky.nyssr.network.packets.IPacketFactoryRegistry;
import java.util.HashMap;
import java.util.Map;

final class CPacketFactoryRegistry
implements IPacketFactoryRegistry {
    private static final ILogger LOG = CLoggerFactory.getLogger(CPacketFactoryRegistry.class);
    private final Map<EPacketType, IPacketFactory> mFactories = new HashMap<EPacketType, IPacketFactory>();

    CPacketFactoryRegistry() {
    }

    @Override
    public void deregisterPacketFactory(IPacketFactory aFactory) {
        EPacketType type = aFactory.getType();
        if (!this.mFactories.containsKey((Object)type)) {
            this.mFactories.remove((Object)type);
        }
    }

    @Override
    public IPacketFactory getPacketFactory(EPacketType aType) {
        IPacketFactory factory = this.mFactories.get((Object)aType);
        if (factory == null) {
            LOG.error("Unknown Packet Type {}", new Object[]{aType});
        }
        return factory;
    }

    @Override
    public void registerPacketFactory(IPacketFactory aFactory) {
        EPacketType type = aFactory.getType();
        this.mFactories.put(type, aFactory);
    }
}

