/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.index;

import de.sillysky.nyssr.impl.network.index.CNetworkIndexApi;
import de.sillysky.nyssr.impl.network.index.IDependencies;
import de.sillysky.nyssr.network.router.IRouter;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.service.IServiceStarter;
import de.sillysky.nyssr.target.listener.IListenerRegistry;
import org.jetbrains.annotations.NotNull;

public class CPackageImplNetworkIndex
implements IServiceStarter,
IDependencies {
    private IService mService;
    private IRouter mRouter;
    private IListenerRegistry mListenerRegistry;

    public void getDependencies(@NotNull IServiceDependencyList aDependencyList) {
        aDependencyList.add(IRouter.class);
        aDependencyList.add(IListenerRegistry.class);
    }

    public void start(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        if (this.mService == null) {
            this.mRouter = (IRouter)aServiceRegistry.getServiceOrThrow(IRouter.class);
            this.mListenerRegistry = (IListenerRegistry)aServiceRegistry.getServiceOrThrow(IListenerRegistry.class);
            this.mService = new CNetworkIndexApi(this);
            this.mService.activate(aServiceRegistry);
        }
    }

    public void stop(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        if (this.mService != null) {
            this.mService.deactivate(aServiceRegistry);
            this.mService = null;
        }
    }

    @Override
    @NotNull
    public IRouter getRouter() {
        return this.mRouter;
    }

    @Override
    @NotNull
    public IListenerRegistry getListenerRegistry() {
        return this.mListenerRegistry;
    }
}

