/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.client.node.ui;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.app.factory.collector.CConstantsAppFactoryCollector;
import de.sillysky.nyssr.app.factory.collector.records.CRecordApplication;
import de.sillysky.nyssr.app.factory.collector.records.CRecordGetApplicationListForUser;
import de.sillysky.nyssr.app.factory.collector.records.CRecordLaunchApplication;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.file.store.api.EFileDeliveryType;
import de.sillysky.nyssr.file.store.records.CRecordFileStoreRequestFile;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.common.CWellKnownNID;
import de.sillysky.nyssr.impl.client.node.ui.CAppEntry;
import de.sillysky.nyssr.impl.client.node.ui.EStatus;
import de.sillysky.nyssr.impl.client.node.ui.IClientNodeDependencies;
import de.sillysky.nyssr.impl.client.node.ui.INodeClient;
import de.sillysky.nyssr.impl.client.node.ui.choose.CFrameAppChooser2;
import de.sillysky.nyssr.impl.client.node.ui.connect.CConnectDialog;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.login.records.CRecordSessionLogin;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.message.CMessage;
import de.sillysky.nyssr.microservice.registry.helper.records.CRecordNotifyMicroServiceRegistryCreated;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.nanoservice.INanoServiceRegistry;
import de.sillysky.nyssr.notification.records.CRecordNotifyRemoteNodeAdded;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.result.CResult;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.session.CConstantsSession;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.tcp.records.CRecordTcpCreateClient;
import de.sillysky.nyssr.tcp.records.CRecordTcpCreateClientRetry;
import de.sillysky.nyssr.tcp.records.CRecordTcpDeleteClient;
import de.sillysky.nyssr.timer.CTimer;
import de.sillysky.nyssr.util.CUtilInteger;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.CUtilUuid;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

class CUiStarterTarget
extends CTarget
implements IService,
INodeClient {
    private static final IId TIMER = CIdFactory.random((String)"Timer");
    private static final ILogger LOG = CLoggerFactory.getLogger(CUiStarterTarget.class);
    private static final String CLIENT_NODE = "ClientNode";
    private static final int TIMEOUT_TIMER = 100;
    private static final long TIMEOUT_RETRY = 5000L;
    private static final int DEFAULT_PORT = 3000;
    final List<CAppEntry> mAppEntries = new ArrayList<CAppEntry>();
    private final IClientNodeDependencies mDependencies;
    private UUID mConnectionId;
    private CConnectDialog mDlg;
    private CTimer mTimer;
    private int mRetryCount;
    private long mTimeout;
    private int mMaxTimer = 34;
    private EStatus mStatus = EStatus.NOTHING;
    private boolean mMicroServiceRegistryAvailable = false;
    private byte[] mSessionToken;
    private String mUserId;
    private String mPasswordHash;
    private CFrameAppChooser2 mMainFrame;
    private CNodeAddress mNetNode;

    CUiStarterTarget(@NotNull IClientNodeDependencies aDependencies) {
        this.mDependencies = aDependencies;
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordTcpCreateClient.ID, this::asyncCreateClient);
        this.addMessageHandler(CRecordNotifyRemoteNodeAdded.ID, this::asyncNotifyRemoteNodeAdded);
        this.addMessageHandler(CRecordNotifyMicroServiceRegistryCreated.ID, this::asyncNotifyMicroServiceRegistryCreated);
        this.addMessageHandler(CRecordTcpCreateClientRetry.ID, this::asyncCreateClientRetry);
        this.addMessageHandler(CRecordTcpDeleteClient.ID, this::asyncTcpDeleteClient);
        this.addMessageHandler(TIMER, this::asyncTimer);
        this.addMessageHandler(CRecordSessionLogin.ID, this::asyncSessionLogin);
        this.addMessageHandler(CRecordGetApplicationListForUser.ID, this::asyncGetApplicationListForUser);
        this.addMessageHandler(CRecordFileStoreRequestFile.ID, this::asyncLfsGetFile);
        this.addMessageHandler(CRecordLaunchApplication.ID, this::asyncLaunchApplication);
        IId nid = CIdFactory.random((String)CLIENT_NODE);
        INamespace ns = this.mDependencies.getNamespaceFactory().createAndRegisterNamespace(nid, CLIENT_NODE);
        ns.getTargetRegistry().registerTarget((ITarget)this);
        SwingUtilities.invokeLater(() -> {
            this.mDlg = new CConnectDialog(this, this.mDependencies);
            this.mDlg.setVisible(true);
        });
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        this.mTimer = new CTimer(this.mDependencies.getTimerManager(), TIMER, this.getAddress(), 100L, false, null);
        INamespace ns = this.mDependencies.getNamespaceFactory().getNamespace(CWellKnownNID.SYSTEM);
        assert (ns != null);
        INanoServiceRegistry nsr = ns.getNanoServiceRegistry();
        nsr.addObserver(CRecordNotifyRemoteNodeAdded.ID, this.getAddress(), false);
        nsr.addObserver(CRecordNotifyMicroServiceRegistryCreated.ID, this.getAddress(), false);
        return true;
    }

    private boolean asyncCreateClient(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            int resultCode = aEnvelope.getResultCode();
            if (resultCode != 0) {
                this.setStatus(EStatus.NOTHING);
            }
            LOG.info("Result creating Tcp Client: {}", new Object[]{aEnvelope.getResult()});
        }
        return true;
    }

    private boolean asyncCreateClientRetry(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        this.mRetryCount = CRecordTcpCreateClientRetry.getRetryCount((CRecord)aRecord, (int)0);
        this.mTimeout = CRecordTcpCreateClientRetry.getTimeout((CRecord)aRecord, (long)0L);
        this.mDlg.setRetryTimeout((int)this.mTimeout, this.mTimer.getCounter(), this.mRetryCount);
        this.mTimer.resetCounter();
        this.mTimer.startIfElseReset();
        return true;
    }

    private boolean asyncTimer(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        this.mTimer.notifyTriggerOccurred();
        int counter = this.mTimer.getCounter() + 1;
        this.mMaxTimer = Math.max(this.mMaxTimer, counter);
        if (this.mDlg != null) {
            this.mDlg.setRetryTimeout((int)this.mTimeout, (int)((long)counter * 5000L / (long)this.mMaxTimer), this.mRetryCount);
        }
        this.mTimer.startIf();
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncTcpDeleteClient(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            this.setStatus(EStatus.NOTHING);
            return true;
        }
        return false;
    }

    private boolean asyncNotifyRemoteNodeAdded(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CNodeAddress node = CRecordNotifyRemoteNodeAdded.getRemoteNode((CRecord)aRecord, null);
        if (node != null) {
            LOG.info("Detected: Remote Node registered: {}", new Object[]{node});
            if (this.mNetNode == null) {
                this.mNetNode = node;
                if (this.mStatus == EStatus.CONNECTING) {
                    this.setStatus(EStatus.CONNECTED);
                    this.login(this.mUserId, this.mPasswordHash);
                }
            }
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncNotifyMicroServiceRegistryCreated(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        LOG.info("Detected: MicroServiceRegistry available");
        this.mMicroServiceRegistryAvailable = true;
        if (this.mStatus == EStatus.LOGIN_PENDING) {
            this.login(this.mUserId, this.mPasswordHash);
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncSessionLogin(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            int resultCode = aEnvelope.getResultCode();
            LOG.info("Session LogIn: {}", new Object[]{aEnvelope.getResult()});
            if (resultCode == 0) {
                this.setStatus(EStatus.LOGGED_IN);
                this.mSessionToken = aEnvelope.getSessionToken();
                this.mDlg.dispose();
                this.mDlg = null;
                this.getApps();
            } else {
                this.setStatus(EStatus.LOGIN_ERROR);
            }
            return true;
        }
        return false;
    }

    private boolean asyncGetApplicationListForUser(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            CRecord[] records;
            LOG.debug("Get Apps: " + aEnvelope.getResult());
            if (aEnvelope.getResultCode() == 0 && (records = CRecordGetApplicationListForUser.getApplicationList((CRecord)aRecord, null)) != null) {
                this.mAppEntries.clear();
                for (CRecord rec : records) {
                    UUID id = CRecordApplication.getId((CRecord)rec, null);
                    String iconPath = CRecordApplication.getIcon((CRecord)rec, (String)"");
                    String applicationName = CRecordApplication.getName((CRecord)rec, (String)"");
                    String shortDescription = CRecordApplication.getShortDescription((CRecord)rec, (String)"");
                    String longDescription = CRecordApplication.getLongDescription((CRecord)rec, (String)"");
                    CAppEntry entry = new CAppEntry(id, applicationName, shortDescription, longDescription, iconPath);
                    LOG.debug("App: " + entry);
                    this.mAppEntries.add(entry);
                    if (!CUtilString.isValid((String)iconPath)) continue;
                    this.requestIcon(entry);
                }
                SwingUtilities.invokeLater(() -> {
                    this.mMainFrame = new CFrameAppChooser2(this, this.mAppEntries);
                    this.mMainFrame.setVisible(true);
                });
            }
            return true;
        }
        return false;
    }

    private boolean asyncLfsGetFile(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            UUID transactionId;
            CResult result = aEnvelope.getResult();
            if (result.isSuccess() && (transactionId = aEnvelope.getTransactionId()) != null) {
                for (CAppEntry appEntry : this.mAppEntries) {
                    if (!transactionId.equals(appEntry.getTransactionId())) continue;
                    byte[] bytes = CRecordFileStoreRequestFile.getBytes((CRecord)aRecord, null);
                    String path = CRecordFileStoreRequestFile.getPath((CRecord)aRecord, null);
                    if (bytes == null) continue;
                    SwingUtilities.invokeLater(() -> {
                        ImageIcon image = new ImageIcon(bytes, path);
                        appEntry.setIcon(image);
                        if (this.mMainFrame != null) {
                            this.mMainFrame.updateIfCurrentDisplayedAppEntry(appEntry);
                        }
                    });
                }
            }
            return true;
        }
        return false;
    }

    private boolean asyncLaunchApplication(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            int resultCode = aEnvelope.getResultCode();
            if (resultCode != 0) {
                UUID applicationId = CRecordLaunchApplication.getApplicationId((CRecord)aRecord, null);
                LOG.error("Couldn't launch application {}: {}", new Object[]{applicationId, aEnvelope.getResultText()});
            }
            return true;
        }
        return false;
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
    }

    @Override
    public void notifyConnectCanceled() {
        this.mTimer.dismiss();
        this.mTimer.resetCounter();
        try {
            this.stopConnecting(this.mConnectionId);
        }
        catch (CException cException) {
            // empty catch block
        }
    }

    @Override
    public void disconnect() {
        this.setStatus(EStatus.DISCONNECTING);
        this.notifyConnectCanceled();
    }

    @Override
    public void doConnect(@NotNull String aNodeAddress, @NotNull String aUserId, @NotNull String aPasswordHashBase64) {
        this.setStatus(EStatus.CONNECTING);
        try {
            String nodeAddress = aNodeAddress.trim();
            int port = 3000;
            String[] split = nodeAddress.split(":");
            if (split.length == 2) {
                nodeAddress = split[0].trim();
                port = CUtilInteger.fromString((String)split[1].trim(), (int)3000);
            }
            this.mConnectionId = this.connect(nodeAddress, port, aUserId, aPasswordHashBase64);
        }
        catch (CException aE) {
            LOG.error((Throwable)aE, "Error sending Message to TCP");
        }
    }

    @Override
    public void dismissDialog() {
        this.mDlg = null;
        System.exit(-1);
    }

    @Override
    @NotNull
    public EStatus getStatus() {
        return this.mStatus;
    }

    private void setStatus(@NotNull EStatus aStatus) {
        this.mStatus = aStatus;
        if (this.mDlg != null) {
            this.mDlg.updateStatus(this.mStatus);
        }
    }

    @NotNull
    private UUID connect(@NotNull String aNodeAddress, int aPort, @NotNull String aUserId, @NotNull String aPasswordHashBase64) throws CException {
        this.mUserId = aUserId;
        this.mPasswordHash = aPasswordHashBase64;
        CEnvelope env = CEnvelope.forLocalNanoService((IId)CWellKnownNID.SYSTEM);
        UUID connectionId = CUtilUuid.random();
        CRecord record = CRecordTcpCreateClient.create();
        CRecordTcpCreateClient.setHost((CRecord)record, (String)aNodeAddress);
        CRecordTcpCreateClient.setPort((CRecord)record, (int)aPort);
        CRecordTcpCreateClient.setId((CRecord)record, (UUID)connectionId);
        CRecordTcpCreateClient.setRetryTimeout((CRecord)record, (long)5000L);
        CRecordTcpCreateClient.setFailOnFirstConnect((CRecord)record, (boolean)false);
        CRecordTcpCreateClient.setWantUpdateOnRetry((CRecord)record, (boolean)true);
        this.sendRequest(env, record);
        return connectionId;
    }

    private void stopConnecting(@NotNull UUID aId) throws CException {
        CEnvelope env = CEnvelope.forLocalNanoService((IId)CWellKnownNID.SYSTEM);
        CRecord record = CRecordTcpDeleteClient.create();
        CRecordTcpDeleteClient.setId((CRecord)record, (UUID)aId);
        this.sendRequest(env, record);
    }

    @Override
    public void login(@NotNull String aUserId, @NotNull String aPasswordHashBase64) throws CException {
        boolean local = this.mNetNode.getSegmentId().isLocal();
        if (local && !this.mMicroServiceRegistryAvailable) {
            this.setStatus(EStatus.LOGIN_PENDING);
            return;
        }
        if (this.mStatus != EStatus.LOGIN) {
            this.setStatus(EStatus.LOGIN);
            this.mUserId = aUserId;
            this.mPasswordHash = aPasswordHashBase64;
            LOG.info("Send LogIn: userId = {}", new Object[]{this.mUserId});
            CRecord record = CRecordSessionLogin.create();
            CRecordSessionLogin.setUserId((CRecord)record, (String)this.mUserId);
            CRecordSessionLogin.setPassword((CRecord)record, (String)this.mPasswordHash);
            if (this.mNetNode.getSegmentId().isLocal()) {
                CEnvelope env = CEnvelope.forMicroService((IId)CConstantsSession.MICRO_SERVICE_ID);
                this.sendRequest(env, record);
            } else {
                CEnvelope env = new CEnvelope();
                env.setSender(this.getAddress());
                env.setWantAnswer(true);
                CMessage msg = new CMessage(env, record);
                this.mDependencies.getMicroServiceRegistryCollector().forwardToMicroService(CConstantsSession.MICRO_SERVICE_ID, msg, this.mNetNode);
            }
        }
    }

    @Override
    public void startApp(@NotNull CAppEntry aEntry) {
        String appName = aEntry.getApplicationName();
        try {
            CEnvelope env = CEnvelope.forMicroService((IId)CConstantsAppFactoryCollector.MICROSERVICE_ID);
            env.setSessionToken(this.mSessionToken);
            CRecord record = CRecordLaunchApplication.create();
            CRecordLaunchApplication.setApplicationId((CRecord)record, (UUID)aEntry.getId());
            CRecordLaunchApplication.setRemoteSkinClientNode((CRecord)record, (CNodeAddress)CNodeAddress.getLocal());
            this.sendRequest(env, record);
        }
        catch (CException aE) {
            LOG.error((Throwable)aE, "Error starting application {}", new Object[]{appName});
        }
    }

    private void getApps() throws CException {
        this.setStatus(EStatus.GET_APPS);
        CEnvelope env = CEnvelope.forMicroService((IId)CConstantsAppFactoryCollector.MICROSERVICE_ID);
        env.setSessionToken(this.mSessionToken);
        CRecord record = CRecordGetApplicationListForUser.create();
        CRecordGetApplicationListForUser.setPlatform((CRecord)record, (String)"swing");
        this.sendRequest(env, record);
    }

    private void requestIcon(@NotNull CAppEntry aEntry) throws CException {
        CEnvelope env = CEnvelope.forLocalNanoService((IId)CWellKnownNID.SYSTEM);
        env.setTransactionId(aEntry.getTransactionId());
        CRecord record = CRecordFileStoreRequestFile.create();
        CRecordFileStoreRequestFile.setPath((CRecord)record, (String)aEntry.getIconPath());
        CRecordFileStoreRequestFile.setDeliveryType((CRecord)record, (byte)EFileDeliveryType.BYTES.getType());
        this.sendRequest(env, record);
    }
}

