/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.httpd;

import fi.iki.elonen.NanoHTTPD;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import org.jetbrains.annotations.NotNull;

class CNanoHttpDaemon
extends NanoHTTPD {
    private final File mDirectory;

    public CNanoHttpDaemon(int aPort, @NotNull Path aDirectory, Path aKeyStorePath, char[] aPassword) throws IOException {
        super(aPort);
        this.mDirectory = aDirectory.toFile();
        this.start(5000, true);
        System.out.println("Server started on port " + aPort);
    }

    public NanoHTTPD.Response serve(@NotNull NanoHTTPD.IHTTPSession aSession) {
        String uri = aSession.getUri();
        File file = new File(this.mDirectory, uri);
        if (file.exists() && file.isFile()) {
            try {
                FileInputStream fis = new FileInputStream(file);
                return CNanoHttpDaemon.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)CNanoHttpDaemon.getMimeTypeForFile((String)uri), (InputStream)fis, (long)file.length());
            }
            catch (IOException e) {
                return CNanoHttpDaemon.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.INTERNAL_ERROR, (String)"text/plain", (String)"Internal Server Error");
            }
        }
        return CNanoHttpDaemon.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.NOT_FOUND, (String)"text/plain", (String)"404 Not Found");
    }

    private static SSLServerSocketFactory makeSSLSocketFactory2(@NotNull String aKeystoreFilePath, char[] aPassphrase) {
        try {
            KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            keystore.load(Files.newInputStream(Paths.get(aKeystoreFilePath, new String[0]), new OpenOption[0]), aPassphrase);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keystore, aPassphrase);
            SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
            sslContext.init(keyManagerFactory.getKeyManagers(), null, null);
            return sslContext.getServerSocketFactory();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

