/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.web.protocol;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.remoteskin.web.dialog.records.CRecordShowWebDialog;
import de.sillysky.nyssr.remoteskin.web.dialog.records.CRecordWebDismissDialog;
import de.sillysky.nyssr.remoteskin.web.dialog.records.CRecordWebNotifyDialogDismissed;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.util.properties.CStringProperties;
import org.jetbrains.annotations.NotNull;

public class CWebDialogApi {
    public static final int REASON_SUCCESS = 0;
    public static final int REASON_ERROR = 1;
    public static final int REASON_CANCELED_BY_USER = 2;
    public static final int REASON_CANCELED_BY_OWNER = 3;
    private final ITarget mTarget;
    private final CTargetAddress mRemoteSkinClientAddress;

    public CWebDialogApi(@NotNull ITarget aTarget, @NotNull CTargetAddress aRemoteSkinClientAddress) {
        this.mTarget = aTarget;
        this.mRemoteSkinClientAddress = aRemoteSkinClientAddress;
    }

    public void showWebDialog(@NotNull IId aMicroServiceId, byte[] aSessionToken, @NotNull String aParentWidgetId, CStringProperties aParams) throws CException {
        CEnvelope env = CEnvelope.forMicroService((IId)aMicroServiceId);
        env.setSessionToken(aSessionToken);
        CRecord record = CRecordShowWebDialog.create();
        CRecordShowWebDialog.setOwnerTargetAddress(record, this.mTarget.getAddress());
        CRecordShowWebDialog.setClientTargetAddress(record, this.mRemoteSkinClientAddress);
        CRecordShowWebDialog.setParentWidgetId(record, aParentWidgetId);
        if (aParams != null && !aParams.isEmpty()) {
            CRecordShowWebDialog.setParams(record, aParams);
        }
        this.mTarget.sendRequest(env, record);
    }

    public void dismissWebDialog(@NotNull CTargetAddress aAddress) throws CException {
        CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)aAddress);
        CRecord record = CRecordWebDismissDialog.create();
        this.mTarget.sendNotification(env, record);
    }

    public void notifyDismissed(@NotNull CTargetAddress aParentAddress, @NotNull IId aMicroServiceId, int aReason, CStringProperties aResults) throws CException {
        CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)aParentAddress);
        CRecord record = CRecordWebNotifyDialogDismissed.create();
        CRecordWebNotifyDialogDismissed.setMicroserviceId(record, aMicroServiceId);
        CRecordWebNotifyDialogDismissed.setReason(record, aReason);
        if (aResults != null) {
            CRecordWebNotifyDialogDismissed.setResults(record, aResults);
        }
        this.mTarget.sendNotification(env, record);
    }
}

