/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model.events.dialogs;

import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonBoolean;
import de.sillysky.nyssr.remoteskin.model.events.CEventColor;
import de.sillysky.nyssr.remoteskin.model.events.IRemoteSkinEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CEventColorChooserDialogNotification
implements IRemoteSkinEvent {
    private static final String COLOR = "color";
    private static final String OKAY = "okay";
    private static final String CANCEL = "cancel";
    private final CEventColor mColor;
    private final boolean mOkay;
    private final boolean mCancel;

    public CEventColorChooserDialogNotification(CEventColor aColor, boolean aOkay, boolean aCancel) {
        this.mColor = aColor;
        this.mOkay = aOkay;
        this.mCancel = aCancel;
    }

    @Nullable
    public static CEventColorChooserDialogNotification create(@Nullable Object aValue) {
        if (aValue instanceof CJsonObject) {
            CJsonObject jo = (CJsonObject)aValue;
            CEventColor color = CEventColor.create(jo.getValue(COLOR));
            boolean okay = CUtilJsonBoolean.fromJson((CJsonObject)jo, (String)OKAY, (boolean)false);
            boolean cancel = CUtilJsonBoolean.fromJson((CJsonObject)jo, (String)CANCEL, (boolean)false);
            return new CEventColorChooserDialogNotification(color, okay, cancel);
        }
        return null;
    }

    @Override
    @NotNull
    public Object toJson() {
        CJsonObject jo = new CJsonObject(true);
        if (this.mColor != null) {
            jo.put(COLOR, this.mColor.toJson());
        }
        if (this.mOkay) {
            jo.put(OKAY, (Object)this.mOkay);
        }
        if (this.mCancel) {
            jo.put(CANCEL, (Object)this.mCancel);
        }
        return jo;
    }

    public CEventColor getColor() {
        return this.mColor;
    }

    public boolean isOkay() {
        return this.mOkay;
    }

    public boolean isCancel() {
        return this.mCancel;
    }
}

