/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model.events;

import de.sillysky.nyssr.json.CJsonArray;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonBoolean;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonString;
import de.sillysky.nyssr.remoteskin.model.enums.ETreeSelectionMode;
import de.sillysky.nyssr.remoteskin.model.events.IRemoteSkinEvent;
import de.sillysky.nyssr.util.CUtilEnum;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CEventTreeSelectionNotification
implements IRemoteSkinEvent {
    static final String LIST_OF_NODES = "nodes";
    static final String SELECTION_MODE = "selectionMode";
    static final String IS_LEAF = "isLeaf";
    static final String ID = "id";
    static final String VALUE = "value";
    private final List<CEntry> mNodes = new ArrayList<CEntry>();
    private ETreeSelectionMode mSelectionMode = ETreeSelectionMode.disabled;
    private boolean mIsLeaf;

    public static CEventTreeSelectionNotification create(@Nullable Object aValue) {
        if (aValue instanceof CJsonObject) {
            CJsonObject jo = (CJsonObject)aValue;
            CEventTreeSelectionNotification event = new CEventTreeSelectionNotification();
            String s = CUtilJsonString.fromJson((CJsonObject)jo, (String)SELECTION_MODE, null);
            ETreeSelectionMode mode = (ETreeSelectionMode)((Object)CUtilEnum.fromString(ETreeSelectionMode.class, (String)s, (Object)((Object)ETreeSelectionMode.disabled)));
            event.setSelectionMode(mode);
            Object o = jo.getValue(LIST_OF_NODES);
            if (o instanceof CJsonArray) {
                CJsonArray arr = (CJsonArray)o;
                for (Object child : arr.getChildren()) {
                    CEntry entry = CEntry.create(child);
                    if (entry == null) continue;
                    event.addSelection(entry);
                }
            }
            return event;
        }
        return null;
    }

    public boolean isLeaf() {
        return this.mIsLeaf;
    }

    public void setIsLeaf(boolean aIsLeaf) {
        this.mIsLeaf = aIsLeaf;
    }

    public void addSelection(@NotNull CEntry aEntry) {
        this.mNodes.add(aEntry);
    }

    @NotNull
    public List<CEntry> getSelectedNodes() {
        return this.mNodes;
    }

    @NotNull
    public ETreeSelectionMode getSelectionMode() {
        return this.mSelectionMode;
    }

    public void setSelectionMode(@NotNull ETreeSelectionMode aSelectionMode) {
        this.mSelectionMode = aSelectionMode;
    }

    @Override
    @NotNull
    public Object toJson() {
        CJsonObject jo = new CJsonObject(true);
        jo.put(SELECTION_MODE, (Object)this.mSelectionMode.name());
        CJsonArray arr = new CJsonArray();
        for (CEntry node : this.mNodes) {
            arr.add(node.toJson());
        }
        jo.put(LIST_OF_NODES, (Object)arr);
        return jo;
    }

    public static class CEntry {
        private final String mId;
        private final String mValue;
        private final boolean mIsLeaf;

        public CEntry(@NotNull String aId, @Nullable String aValue, boolean aIsLeaf) {
            this.mId = aId;
            this.mValue = aValue;
            this.mIsLeaf = aIsLeaf;
        }

        @Nullable
        static CEntry create(@Nullable Object aValue) {
            CJsonObject jo;
            String id;
            if (aValue instanceof CJsonObject && !(id = CUtilJsonString.fromJson((CJsonObject)(jo = (CJsonObject)aValue), (String)CEventTreeSelectionNotification.ID, (String)"")).isEmpty()) {
                String value = CUtilJsonString.fromJson((CJsonObject)jo, (String)CEventTreeSelectionNotification.VALUE, (String)"");
                boolean isLeaf = CUtilJsonBoolean.fromJson((CJsonObject)jo, (String)CEventTreeSelectionNotification.IS_LEAF, (boolean)false);
                return new CEntry(id, value, isLeaf);
            }
            return null;
        }

        @NotNull
        public String getId() {
            return this.mId;
        }

        @Nullable
        public String getValue() {
            return this.mValue;
        }

        public boolean isLeaf() {
            return this.mIsLeaf;
        }

        @NotNull
        public Object toJson() {
            CJsonObject jo = new CJsonObject(true);
            jo.put(CEventTreeSelectionNotification.ID, (Object)this.mId);
            jo.put(CEventTreeSelectionNotification.VALUE, (Object)this.mValue);
            jo.put(CEventTreeSelectionNotification.IS_LEAF, (Object)this.mIsLeaf);
            return jo;
        }
    }
}

