/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model.events;

import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonInteger;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonString;
import de.sillysky.nyssr.remoteskin.model.events.IRemoteSkinEvent;
import de.sillysky.nyssr.util.CUtilString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CEventReplaceText
implements IRemoteSkinEvent {
    private static final String TEXT = "text";
    private static final String POS_START = "posStart";
    private static final String POS_END = "posEnd";
    private final String mText;
    private final int mPositionStart;
    private final int mPositionEnd;

    public CEventReplaceText(@NotNull String aText, int aPositionStart, int aPositionEnd) {
        this.mText = aText;
        this.mPositionStart = aPositionStart;
        this.mPositionEnd = aPositionEnd;
    }

    @Nullable
    public static CEventReplaceText create(@Nullable Object aValue) {
        if (aValue instanceof CJsonObject) {
            CJsonObject jo = (CJsonObject)aValue;
            String text = CUtilJsonString.fromJson((CJsonObject)jo, (String)TEXT, null);
            int posStart = CUtilJsonInteger.fromJson((CJsonObject)jo, (String)POS_START, (int)-1);
            int posEnd = CUtilJsonInteger.fromJson((CJsonObject)jo, (String)POS_END, (int)-1);
            if (CUtilString.isValid((String)text)) {
                return new CEventReplaceText(text, posStart, posEnd);
            }
        }
        return null;
    }

    @Override
    @NotNull
    public Object toJson() {
        CJsonObject jo = new CJsonObject(true);
        jo.put(TEXT, (Object)this.mText);
        if (this.mPositionStart >= 0) {
            jo.put(POS_START, (Object)this.mPositionStart);
        }
        if (this.mPositionEnd >= 0) {
            jo.put(POS_END, (Object)this.mPositionEnd);
        }
        return jo;
    }

    public String getText() {
        return this.mText;
    }

    public int getPositionStart() {
        return this.mPositionStart;
    }

    public int getPositionEnd() {
        return this.mPositionEnd;
    }
}

