/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.net.connection.printer;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.cli.records.CRecordCliHandle;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.common.CWellKnownNID;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.network.router.records.CRecordNetworkGetLinks;
import de.sillysky.nyssr.network.router.records.CRecordNetworkLinkData;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;

class CWorkingTarget
extends CTarget {
    private final CEnvelope mEnvelope;
    private final CRecord mRecord;

    CWorkingTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        this.mEnvelope = aEnvelope;
        this.mRecord = aRecord;
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordNetworkGetLinks.ID, this::asyncGetLinks);
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.requestLinks();
        return true;
    }

    private boolean asyncGetLinks(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            CRecord[] links = CRecordNetworkGetLinks.getLinks((CRecord)aRecord, null);
            StringBuilder sb = new StringBuilder(2000);
            if (links == null || links.length == 0) {
                sb.append("No links found.");
            } else {
                TreeSet<String> nodes = new TreeSet<String>();
                HashMap<String, List> nodeLinks = new HashMap<String, List>();
                for (CRecord link : links) {
                    CNodeAddress node1 = CRecordNetworkLinkData.getNode1((CRecord)link, null);
                    CNodeAddress node2 = CRecordNetworkLinkData.getNode2((CRecord)link, null);
                    if (node1 == null || node2 == null) continue;
                    String n1 = node1.getNodeId().toString();
                    nodes.add(n1);
                    String n2 = node2.getNodeId().toString();
                    nodes.add(n2);
                    List ll = nodeLinks.computeIfAbsent(n1, k -> new ArrayList());
                    ll.add(n2);
                    ll = nodeLinks.computeIfAbsent(n2, k -> new ArrayList());
                    ll.add(n1);
                }
                for (String node : nodes) {
                    sb.append(node).append(": ");
                    List ll = (List)nodeLinks.get(node);
                    for (String link : ll) {
                        sb.append(link).append(" ");
                    }
                    sb.append("\n");
                }
            }
            this.finish(sb.toString());
            return true;
        }
        return false;
    }

    private void requestLinks() throws CException {
        CEnvelope env = CEnvelope.forLocalNanoService((IId)CWellKnownNID.SYSTEM);
        CRecord record = CRecordNetworkGetLinks.create();
        CRecordNetworkGetLinks.setOnlyLocalSegment((CRecord)record, (boolean)true);
        this.sendRequest(env, record);
    }

    private void finish(@NotNull String aText) throws CException {
        CRecordCliHandle.setOutput((CRecord)this.mRecord, (String)aText);
        this.mEnvelope.setResultSuccess();
        this.mEnvelope.setBlocked(false);
        this.getMessageSender().sendBack(this.mEnvelope, this.mRecord);
        this.deregisterTarget();
    }
}

