/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.web.dialog.revokerights;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.web.dialog.revokerights.CConstants;
import de.sillysky.nyssr.json.CUtilJson;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.remoteskin.web.dialog.records.CRecordWebDismissDialog;
import de.sillysky.nyssr.remoteskin.web.protocol.CWebApi;
import de.sillysky.nyssr.remoteskin.web.protocol.CWebDialogApi;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebNotifyClick1;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebNotifyClick2;
import de.sillysky.nyssr.session.CConstantsSession;
import de.sillysky.nyssr.session.api.CRight;
import de.sillysky.nyssr.session.api.records.CRecordUserDbGetRightListForRole;
import de.sillysky.nyssr.session.api.records.CRecordUserDbRevokeRightFromRole;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.CUtilStringArray;
import de.sillysky.nyssr.util.properties.CStringProperties;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;

class C00314RevokeRights
extends CTarget {
    private static final String HTML_00314_MAIN = "/html/00314_main.html";
    private static final String STYLE_SHEET_ID = "id_00314_css";
    private final byte[] mSessionToken;
    private final CTargetAddress mClientTargetAddress;
    private final CTargetAddress mOwnerTargetAddress;
    private final String mRoleId;
    private CWebApi mWebApi;
    private CWebDialogApi mWebDialogApi;
    private static final String ID_INDEX_MODAL = "rs_30cb3f8d-cefd-40c5-81b8-7791895c7b95";
    private static final String ID_00314_MODAL = "id_00314_modal";
    private static final String ID_00314_CANCEL = "id_00314_cancel";
    private static final String ID_00314_SAVE = "id_00314_save";
    private static final String ID_00314_SELECT = "id_00314_select";
    private static final String[] WIDGETS = new String[]{"id_00314_cancel", "id_00314_save"};
    private CTargetAddress mUserDbAddress;
    private final TreeSet<CRight> mRoleRights = new TreeSet();

    public C00314RevokeRights(byte[] aSessionToken, @NotNull CTargetAddress aClientTargetAddress, @NotNull CTargetAddress aOwnerTargetAddress, @NotNull String aRoleId) {
        this.mSessionToken = aSessionToken;
        this.mClientTargetAddress = aClientTargetAddress;
        this.mOwnerTargetAddress = aOwnerTargetAddress;
        this.mRoleId = aRoleId;
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordWebDismissDialog.ID, this::asyncWebDismissDialog);
        this.addMessageHandler(CRecordWebNotifyClick1.ID, this::asyncWebNotifyClick1);
        this.addMessageHandler(CRecordWebNotifyClick2.ID, this::asyncWebNotifyClick2);
        this.addMessageHandler(CRecordUserDbGetRightListForRole.ID, this::asyncGetRightListForRole);
        this.addMessageHandler(CRecordUserDbRevokeRightFromRole.ID, this::asyncUserDbRevokeRightFromRole);
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.mWebApi = new CWebApi((ITarget)this, this.mClientTargetAddress);
        this.mWebDialogApi = new CWebDialogApi((ITarget)this, this.mClientTargetAddress);
        this.sendGetRightsForRole(this.mRoleId);
        this.mWebApi.registerWidgets(WIDGETS);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncWebDismissDialog(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.finish(3);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncWebNotifyClick1(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CStringProperties values = CRecordWebNotifyClick1.getValues((CRecord)aRecord, null);
        if (values != null) {
            String arrText = values.get(ID_00314_SELECT, "");
            if (arrText != null && !arrText.isEmpty()) {
                @NotNull String[] arr = CUtilStringArray.fromString((String)arrText);
                this.sendRevokeRights(this.mRoleId, arr);
            }
        } else {
            this.finish(1);
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncWebNotifyClick2(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.finish(2);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncGetRightListForRole(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            this.mUserDbAddress = aEnvelope.getSender();
            if (aEnvelope.getResult().isSuccess()) {
                CRecord[] rightRecords = CRecordUserDbGetRightListForRole.getRights((CRecord)aRecord, null);
                this.mRoleRights.clear();
                if (rightRecords != null) {
                    for (CRecord rightRecord : rightRecords) {
                        CRight right = CRight.fromRecord((CRecord)rightRecord);
                        this.mRoleRights.add(right);
                    }
                }
                this.showDialog();
            } else {
                this.finish(1);
            }
            return true;
        }
        return false;
    }

    private boolean asyncUserDbRevokeRightFromRole(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            int resultCode = aEnvelope.getResultCode();
            if (resultCode == 0) {
                this.mUserDbAddress = aEnvelope.getSender();
                this.finish(0);
            } else {
                this.finish(1);
            }
            return true;
        }
        return false;
    }

    private void showDialog() throws CException {
        this.mWebApi.addCss(STYLE_SHEET_ID, CUtilJson.loadJson(((Object)((Object)this)).getClass(), (String)"/html/00314.css"));
        this.mWebApi.removeElement(ID_00314_MODAL);
        String myMain = CUtilJson.loadJson(((Object)((Object)this)).getClass(), (String)HTML_00314_MAIN);
        myMain = CUtilString.replaceAllOccurrences((String)myMain, (String)"{role_id}", (String)this.mRoleId);
        for (CRight right : this.mRoleRights) {
            String sb = "<option value='" + right + "'>" + right + "</option>";
            myMain = CUtilString.insertBeforeFirstOccurrence((String)myMain, (String)"{row}", (String)sb);
        }
        myMain = CUtilString.replaceFirstOccurrence((String)myMain, (String)"{row}", (String)"");
        this.mWebApi.setInnerHtml(ID_INDEX_MODAL, myMain);
        this.mWebApi.showModal(ID_00314_MODAL);
        this.mWebApi.addClickListener1(ID_00314_SAVE, new String[]{ID_00314_SELECT});
        this.mWebApi.addClickListener2(new String[]{ID_00314_CANCEL});
    }

    private void sendGetRightsForRole(@NotNull String aRoleId) throws CException {
        CRecord record = CRecordUserDbGetRightListForRole.create();
        CRecordUserDbGetRightListForRole.setRoleId((CRecord)record, (String)aRoleId);
        this.sendMessageToSessionManager(record);
    }

    private void sendRevokeRights(@NotNull String aRoleId, @NotNull @NotNull String @NotNull [] aRights) throws CException {
        CRecord record = CRecordUserDbRevokeRightFromRole.create();
        CRecordUserDbRevokeRightFromRole.setRoleId((CRecord)record, (String)aRoleId);
        CRecordUserDbRevokeRightFromRole.setRightIds((CRecord)record, (String[])aRights);
        this.sendMessageToSessionManager(record);
    }

    private void sendMessageToSessionManager(@NotNull CRecord aRecord) throws CException {
        CEnvelope env = this.mUserDbAddress != null ? CEnvelope.forSingleTarget((CTargetAddress)this.mUserDbAddress) : CEnvelope.forMicroService((IId)CConstantsSession.MICRO_SERVICE_ID);
        env.setSessionToken(this.mSessionToken);
        this.sendRequest(env, aRecord);
    }

    private void finish(int aReason) throws CException {
        this.mWebApi.removeCss(STYLE_SHEET_ID);
        this.mWebApi.removeElement(ID_00314_MODAL);
        CStringProperties sp = new CStringProperties();
        sp.put("roleId", this.mRoleId);
        this.mWebDialogApi.notifyDismissed(this.mOwnerTargetAddress, CConstants.MICRO_SERVICE_ID, aReason, sp);
        this.mWebApi.deregisterWidgetOwner();
        this.deregisterTarget();
    }
}

