/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.app.widget.showcase.main;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.widget.CWidgetId;
import de.sillysky.nyssr.impl.app.widget.showcase.IAppContext;
import de.sillysky.nyssr.impl.app.widget.showcase.main.CMainFrameModel;
import de.sillysky.nyssr.impl.app.widget.showcase.main.CMainFrameUi;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.message.panel.CConstants;
import de.sillysky.nyssr.message.panel.records.CRecordOpenDialogMessagePanel;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.remoteskin.server.connector.IRemoteSkinClientContext;
import de.sillysky.nyssr.remoteskin.server.dialog.CUtilDialogHelper;
import de.sillysky.nyssr.remoteskin.server.dialog.records.CRecordCloseDialog;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CMainFrameTarget
extends CTarget {
    private final CMainFrameModel mModel;
    private final CMainFrameUi mUi;
    private final List<ITarget> mTargets = new ArrayList<ITarget>();

    public CMainFrameTarget(IAppContext aAppContext) {
        this.mModel = new CMainFrameModel(this, aAppContext);
        this.mUi = new CMainFrameUi(this.mModel);
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordOpenDialogMessagePanel.ID, this::asyncOpenDialogMessagePanel);
    }

    void onWidgetSetMounted() {
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        this.mUi.mountWidgetSet300();
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncOpenDialogMessagePanel(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            if (aEnvelope.getResultCode() == 0) {
                CTargetAddress address = CRecordOpenDialogMessagePanel.getDialogTargetAddress((CRecord)aRecord, null);
                this.mModel.getAppContext().setMessagePanelAddress(address);
            }
            return true;
        }
        return false;
    }

    public void deactivate() throws CException {
        this.sendDismissMessagePanel();
        for (ITarget target : this.mTargets) {
            target.deregisterTarget();
        }
        this.mTargets.clear();
        this.deregisterTarget();
    }

    void showHistory() throws CException {
        IAppContext appContext = this.mModel.getAppContext();
        CEnvelope env = CEnvelope.forMicroService((IId)CConstants.MESSAGE_HISTORY_PANEL);
        env.setSessionToken(appContext.getApplicationContext().getSessionToken());
        IRemoteSkinClientContext clientContext = appContext.getRemoteSkinClientContext();
        CRecord rec1 = CRecordOpenDialogMessagePanel.create();
        CRecordOpenDialogMessagePanel.setPanelType((CRecord)rec1, (int)400);
        CRecordOpenDialogMessagePanel.setCenterDlgAbove((CRecord)rec1, (CWidgetId)CWidgetId.create((String)"#300_MainFrame", (String)"@300_MainFrame", (String)"main"));
        CUtilDialogHelper.enrichOpenDialogRecord((CRecord)rec1, (IRemoteSkinClientContext)clientContext, (CWidgetId)this.mUi.getMessagePanel());
        this.sendRequest(env, rec1);
    }

    private void sendDismissMessagePanel() throws CException {
        CTargetAddress adr = this.mModel.getAppContext().getMessagePanelAddress();
        if (adr != null) {
            CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)adr);
            CRecord record = CRecordCloseDialog.create();
            this.sendNotification(env, record);
        }
    }
}

