/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.web.dialog.rightlist;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.impl.web.dialog.rightlist.CConstants;
import de.sillysky.nyssr.json.CUtilJson;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.remoteskin.web.dialog.records.CRecordWebDismissDialog;
import de.sillysky.nyssr.remoteskin.web.dialog.records.CRecordWebNotifyDialogDismissed;
import de.sillysky.nyssr.remoteskin.web.protocol.CWebApi;
import de.sillysky.nyssr.remoteskin.web.protocol.CWebDialogApi;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebNotifyClick2;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebNotifyTableRowClicked;
import de.sillysky.nyssr.session.CConstantsSession;
import de.sillysky.nyssr.session.api.CRight;
import de.sillysky.nyssr.session.api.records.CRecordUserDbDeleteRight;
import de.sillysky.nyssr.session.api.records.CRecordUserDbGetRightList;
import de.sillysky.nyssr.session.api.records.CRecordUserDbGetRightRecord;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.properties.CStringProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

class C00312RightList
extends CTarget {
    private static final IId MICRO_SERVICE_EDIT_RIGHT = CIdFactory.fromObject((Object)"NY_WebDialogEditRight_00304");
    private static final IId MICRO_SERVICE_ADD_RIGHT = CIdFactory.fromObject((Object)"NY_WebDialogAddRight_00305");
    private static final IId MICRO_SERVICE_YES_NO = CIdFactory.fromObject((Object)"NY_WebDialogYesNo_00001");
    private final byte[] mSessionToken;
    private final CTargetAddress mClientTargetAddress;
    private final CTargetAddress mOwnerTargetAddress;
    private final String mParentWidgetId;
    private CWebApi mWebApi;
    private CWebDialogApi mWebDialogApi;
    private final Map<IId, CTargetAddress> mRunningMicroServices = new HashMap<IId, CTargetAddress>(10);
    private static final String ID_00312_DESCRIPTION = "id_00312_description";
    private static final String ID_00312_RIGHT_ID = "id_00312_right_id";
    private static final String ID_TABLE_RIGHTS = "id_00312_table_rights";
    private static final String ID_EDIT_RIGHT = "id_00312_edit_right";
    private static final String ID_DELETE_RIGHT = "id_00312_delete_right";
    private static final String ID_ADD_RIGHT = "id_00312_add_right";
    private static final String[] WIDGETS = new String[]{"id_00312_edit_right", "id_00312_delete_right", "id_00312_add_right"};
    private CTargetAddress mUserDbAddress;
    private List<CRight> mSortedRightList = new ArrayList<CRight>();
    private CRight mRight;
    private String mNextRight;

    public C00312RightList(byte[] aSessionToken, @NotNull CTargetAddress aClientTargetAddress, @NotNull CTargetAddress aOwnerTargetAddress, @NotNull String aParentWidgetId) {
        this.mSessionToken = aSessionToken;
        this.mClientTargetAddress = aClientTargetAddress;
        this.mOwnerTargetAddress = aOwnerTargetAddress;
        this.mParentWidgetId = aParentWidgetId;
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordWebDismissDialog.ID, this::asyncWebDismissDialog);
        this.addMessageHandler(CRecordWebNotifyClick2.ID, this::asyncWebNotifyClick2);
        this.addMessageHandler(CRecordUserDbGetRightList.ID, this::asyncGetRightList);
        this.addMessageHandler(CRecordUserDbGetRightRecord.ID, this::asyncGetRightRecord);
        this.addMessageHandler(CRecordWebNotifyTableRowClicked.ID, this::asyncWebNotifyTableRowClicked);
        this.addMessageHandler(CRecordWebNotifyDialogDismissed.ID, this::asyncNotifyDialogDismissed);
        this.addMessageHandler(CRecordUserDbDeleteRight.ID, this::asyncDeleteRight);
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.mWebApi = new CWebApi((ITarget)this, this.mClientTargetAddress);
        this.mWebDialogApi = new CWebDialogApi((ITarget)this, this.mClientTargetAddress);
        this.sendGetAllRights();
        this.mWebApi.registerWidgets(WIDGETS);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncWebDismissDialog(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.finish(3);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncWebNotifyClick2(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        String id = CRecordWebNotifyClick2.getId((CRecord)aRecord, null);
        CUtilCheck.checkNotNullEx((Object)id, (String)"Missing id on onClick", (Object[])new Object[0]);
        switch (id) {
            case "id_00312_edit_right": {
                this.openDialogEditRight();
                break;
            }
            case "id_00312_add_right": {
                this.openDialogAddRight();
                break;
            }
            case "id_00312_delete_right": {
                this.openDialogYesNo("Would you like to delete right " + this.mRight.getId() + "?");
            }
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncGetRightList(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            if (aEnvelope.getResult().isSuccess()) {
                this.mUserDbAddress = aEnvelope.getSender();
                CRecord[] rightRecords = CRecordUserDbGetRightList.getRights((CRecord)aRecord, null);
                ArrayList<CRight> rightList = new ArrayList<CRight>();
                if (rightRecords != null) {
                    for (CRecord rightRecord : rightRecords) {
                        CRight right = CRight.fromRecord((CRecord)rightRecord);
                        rightList.add(right);
                    }
                    this.mSortedRightList = rightList.stream().sorted(CRight::compareTo).collect(Collectors.toList());
                }
                this.createRightTable();
            } else {
                this.finish(1);
            }
            return true;
        }
        return false;
    }

    private boolean asyncGetRightRecord(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            if (aEnvelope.getResult().isSuccess()) {
                this.mUserDbAddress = aEnvelope.getSender();
                String id = CRecordUserDbGetRightRecord.getRightId((CRecord)aRecord, null);
                String description = CRecordUserDbGetRightRecord.getDescription((CRecord)aRecord, null);
                this.mRight = new CRight(id, description, false);
                this.showRight(this.mRight);
            } else {
                this.finish(1);
            }
            return true;
        }
        return false;
    }

    private boolean asyncWebNotifyTableRowClicked(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        String id = CRecordWebNotifyTableRowClicked.getId((CRecord)aRecord, null);
        CUtilCheck.checkNotNullEx((Object)id, (String)"Missing id on NotifyTableRowClicked", (Object[])new Object[0]);
        String[] data = CRecordWebNotifyTableRowClicked.getData((CRecord)aRecord, null);
        if (data != null && data.length > 0) {
            String rightId = data[0];
            if (this.mRight != null && !this.mRight.getId().equals(rightId)) {
                this.markCurrentRowInactive(this.mRight.getId());
            }
            this.markRowActive(rightId);
            this.sendGetRightData(rightId);
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncDeleteRight(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            int resultCode = aEnvelope.getResultCode();
            if (resultCode == 0) {
                this.mUserDbAddress = aEnvelope.getSender();
                this.sendGetAllRights();
            }
            return true;
        }
        return false;
    }

    private boolean asyncNotifyDialogDismissed(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.mNextRight = null;
        int reason = CRecordWebNotifyDialogDismissed.getReason((CRecord)aRecord, (int)-1);
        if (reason == 0) {
            String yesOrNo;
            IId microserviceId = CRecordWebNotifyDialogDismissed.getMicroserviceId((CRecord)aRecord, null);
            this.mRunningMicroServices.remove(microserviceId);
            CStringProperties results = CRecordWebNotifyDialogDismissed.getResults((CRecord)aRecord, (CStringProperties)new CStringProperties());
            if (MICRO_SERVICE_EDIT_RIGHT.equals((Object)microserviceId)) {
                this.sendGetRightData(this.mRight.getId());
                this.mNextRight = results.get("rightId");
            } else if (MICRO_SERVICE_ADD_RIGHT.equals((Object)microserviceId)) {
                this.sendGetAllRights();
                this.mNextRight = results.get("rightId");
                this.markRowActive(this.mNextRight);
            } else if (MICRO_SERVICE_YES_NO.equals((Object)microserviceId) && "yes".equals(yesOrNo = results.get("result"))) {
                this.sendDeleteRight();
            }
        } else if (reason == 1) {
            this.finish(reason);
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private void createRightTable() throws CException {
        CRight right;
        String main = CUtilJson.loadJson(((Object)((Object)this)).getClass(), (String)"/html/00312_main.html");
        String table = CUtilJson.loadJson(((Object)((Object)this)).getClass(), (String)"/html/00312_table.html");
        String row = CUtilJson.loadJson(((Object)((Object)this)).getClass(), (String)"/html/00312_row.html");
        String currentTable = table;
        for (CRight right2 : this.mSortedRightList) {
            String currentRow = row;
            currentRow = CUtilString.replaceAllOccurrences((String)currentRow, (String)"{right_id}", (String)right2.toString());
            currentTable = CUtilString.insertBeforeFirstOccurrence((String)currentTable, (String)"{row}", (String)currentRow);
        }
        currentTable = CUtilString.replaceFirstOccurrence((String)currentTable, (String)"{row}", (String)"");
        main = CUtilString.replaceFirstOccurrence((String)main, (String)"{table_rights}", (String)currentTable);
        this.mWebApi.setInnerHtml(this.mParentWidgetId, main);
        this.mWebApi.addTableRowListener(ID_TABLE_RIGHTS);
        if (this.mNextRight == null && (right = this.mSortedRightList.get(0)) != null) {
            this.mNextRight = right.getId();
        }
        if (CUtilString.isValid((String)this.mNextRight)) {
            this.sendGetRightData(this.mNextRight);
            this.markRowActive(this.mNextRight);
        }
    }

    private void sendGetRightData(@NotNull String aId) throws CException {
        CRecord record = CRecordUserDbGetRightRecord.create();
        CRecordUserDbGetRightRecord.setRightId((CRecord)record, (String)aId);
        this.sendMessageToSessionManager(record);
    }

    private void sendMessageToSessionManager(@NotNull CRecord aRecord) throws CException {
        CEnvelope env = this.mUserDbAddress != null ? CEnvelope.forSingleTarget((CTargetAddress)this.mUserDbAddress) : CEnvelope.forMicroService((IId)CConstantsSession.MICRO_SERVICE_ID);
        env.setSessionToken(this.mSessionToken);
        this.sendRequest(env, aRecord);
    }

    private void sendGetAllRights() throws CException {
        CRecord record = CRecordUserDbGetRightList.create();
        this.sendMessageToSessionManager(record);
    }

    private void sendDeleteRight() throws CException {
        CRecord record = CRecordUserDbDeleteRight.create();
        CRecordUserDbDeleteRight.setRight((CRecord)record, (String)this.mRight.getId());
        this.sendMessageToSessionManager(record);
    }

    private void showRight(@NotNull CRight aRight) throws CException {
        this.mWebApi.setInnerHtml(ID_00312_RIGHT_ID, aRight.getId());
        this.mWebApi.setInnerHtml(ID_00312_DESCRIPTION, aRight.getDescription());
    }

    private void openDialogEditRight() throws CException {
        CStringProperties params = new CStringProperties();
        params.put("rightId", this.mRight.getId());
        this.mWebDialogApi.showWebDialog(MICRO_SERVICE_EDIT_RIGHT, this.mSessionToken, "id_00300_modal", params);
    }

    private void openDialogAddRight() throws CException {
        this.mWebDialogApi.showWebDialog(MICRO_SERVICE_ADD_RIGHT, this.mSessionToken, "id_00300_modal", null);
    }

    private void openDialogYesNo(String aMessage) throws CException {
        CStringProperties params = new CStringProperties();
        params.put("message", aMessage);
        this.mWebDialogApi.showWebDialog(MICRO_SERVICE_YES_NO, this.mSessionToken, "id_00300_modal", params);
    }

    private void markCurrentRowInactive(@NotNull String aRightId) throws CException {
        this.mWebApi.removeClassFromElement("#row_" + aRightId, "uk-active");
    }

    private void markRowActive(@NotNull String aRightId) throws CException {
        this.mWebApi.addClassToElement("#row_" + aRightId, "uk-active");
    }

    private void finish(int aReason) throws CException {
        for (CTargetAddress address : this.mRunningMicroServices.values()) {
            CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)address);
            CRecord record = CRecordWebDismissDialog.create();
            this.sendNotification(env, record);
        }
        this.mWebDialogApi.notifyDismissed(this.mOwnerTargetAddress, CConstants.MICRO_SERVICE_ID, aReason, null);
        this.mWebApi.deregisterWidgetOwner();
        this.deregisterTarget();
    }
}

