/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.session.api;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.session.api.records.CRecordUserDbRoleRecord;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.time.CUtilLocalDateTime;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class CRole
implements Comparable<CRole> {
    private String mId;
    private String mDescription;
    private String mCreatedByUser;
    private final LocalDateTime mTimeCreated;
    private boolean mProtected;

    @Contract(value="_ -> new")
    @NotNull
    public static CRole fromRecord(@NotNull CRecord aRecord) throws CException {
        if (!CRecordUserDbRoleRecord.ID.equals((Object)aRecord.getId())) {
            throw new CException(2010);
        }
        String id = CRecordUserDbRoleRecord.getRoleId(aRecord, "");
        CUtilCheck.checkEmptyStringEx((Object)id, (String)"missing role id", (Object[])new Object[0]);
        String description = CRecordUserDbRoleRecord.getDescription(aRecord, "");
        boolean isProtected = CRecordUserDbRoleRecord.getIsProtected(aRecord, false);
        String createdByUser = CRecordUserDbRoleRecord.getCreatedBy(aRecord, "");
        LocalDateTime timeCreated = CRecordUserDbRoleRecord.getTimeCreated(aRecord, LocalDateTime.now());
        return new CRole(id, description, isProtected, createdByUser, timeCreated);
    }

    @NotNull
    public static CRole fromStream(@NotNull DataInputStream aStream) throws IOException, CException {
        String id = CUtilString.fromStream((DataInput)aStream);
        CUtilCheck.checkEmptyStringEx((Object)id, (String)"missing id", (Object[])new Object[0]);
        assert (id != null);
        String desc = CUtilString.fromStream((DataInput)aStream);
        boolean isProtected = aStream.readBoolean();
        String createdBy = CUtilString.fromStream((DataInput)aStream);
        LocalDateTime created = CUtilLocalDateTime.fromStream((DataInput)aStream);
        return new CRole(id, desc == null ? "" : desc, isProtected, createdBy == null ? "" : createdBy, created == null ? LocalDateTime.now() : created);
    }

    public CRole(@NotNull String aId, @NotNull String aDescription, boolean aProtected, @NotNull String aCreatedByUser, @NotNull LocalDateTime aTimeCreated) {
        this.mId = aId;
        this.mDescription = aDescription;
        this.mProtected = aProtected;
        this.mCreatedByUser = aCreatedByUser;
        this.mTimeCreated = aTimeCreated;
    }

    public CRole(@NotNull CRole aRole) {
        this.mId = aRole.mId;
        this.mDescription = aRole.mDescription;
        this.mProtected = aRole.mProtected;
        this.mCreatedByUser = aRole.mCreatedByUser;
        this.mTimeCreated = aRole.mTimeCreated;
    }

    public CRole() {
        this.mId = "";
        this.mDescription = "";
        this.mProtected = false;
        this.mCreatedByUser = "";
        this.mTimeCreated = LocalDateTime.now();
    }

    @NotNull
    public String getId() {
        return this.mId;
    }

    public void setId(@NotNull String aId) {
        this.mId = aId;
    }

    @NotNull
    public String getDescription() {
        return this.mDescription;
    }

    public void setDescription(@NotNull String aDescription) {
        this.mDescription = aDescription;
    }

    public boolean isProtected() {
        return this.mProtected;
    }

    public void setProtected(boolean aIsProtected) {
        this.mProtected = aIsProtected;
    }

    @NotNull
    public String getCreatedByUser() {
        return this.mCreatedByUser;
    }

    public void setCreatedByUser(@NotNull String aCreatedByUser) {
        this.mCreatedByUser = aCreatedByUser;
    }

    @NotNull
    public LocalDateTime getTimeCreated() {
        return this.mTimeCreated;
    }

    public boolean equals(Object aO) {
        if (this == aO) {
            return true;
        }
        if (aO == null || this.getClass() != aO.getClass()) {
            return false;
        }
        CRole role = (CRole)aO;
        return this.mId.equals(role.mId);
    }

    public int hashCode() {
        return Objects.hash(this.mId);
    }

    public CRecord toRecord() throws CException {
        CRecord record = CRecordUserDbRoleRecord.create();
        if (!this.mId.isEmpty()) {
            CRecordUserDbRoleRecord.setRoleId(record, this.mId);
        }
        if (!this.mDescription.isEmpty()) {
            CRecordUserDbRoleRecord.setDescription(record, this.mDescription);
        }
        if (this.mProtected) {
            CRecordUserDbRoleRecord.setIsProtected(record, true);
        }
        if (!this.mCreatedByUser.isEmpty()) {
            CRecordUserDbRoleRecord.setCreatedBy(record, this.mCreatedByUser);
        }
        CRecordUserDbRoleRecord.setTimeCreated(record, this.mTimeCreated);
        return record;
    }

    public void toStream(@NotNull DataOutputStream aStream) throws IOException {
        CUtilString.toStream((DataOutput)aStream, (String)this.mId);
        CUtilString.toStream((DataOutput)aStream, (String)this.mDescription);
        aStream.writeBoolean(this.mProtected);
        CUtilString.toStream((DataOutput)aStream, (String)this.mCreatedByUser);
        CUtilLocalDateTime.toStream((DataOutput)aStream, (LocalDateTime)this.mTimeCreated);
    }

    @Override
    public int compareTo(@NotNull CRole aRole) {
        return this.mId.compareTo(aRole.mId);
    }
}

