/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table;

import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table.CAbstractCellRenderer;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table.CCell;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table.CColumn;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table.CTable;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table.CTableModel;
import de.sillysky.nyssr.util.CUtilDouble;
import de.sillysky.nyssr.util.CUtilString;
import java.awt.Component;
import java.text.DecimalFormat;
import javax.swing.JLabel;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;

public class CTableCellRendererDecimal
extends CAbstractCellRenderer {
    private static final long serialVersionUID = -8245719132035159048L;

    public CTableCellRendererDecimal(CTable aTable) {
        super(aTable);
    }

    @Override
    public Component getTableCellRendererComponent(@NotNull JTable aTable, Object aValue, boolean aIsSelected, boolean aHasFocus, int aRowIndex, int aColumnIndex) {
        int rowIndex = this.getTable().convertRowIndexToModel(aRowIndex);
        double theValue = CUtilDouble.fromObject((Object)aValue, (double)0.0);
        CTableModel model = this.getTable().getMyModel();
        CColumn column = model.getColumnModel().getColumnByIndex(aColumnIndex);
        CCell cell = model.getCellOrNull(aColumnIndex, rowIndex);
        JLabel component = (JLabel)super.getTableCellRendererComponent(aTable, theValue, aIsSelected, aHasFocus, aRowIndex, aColumnIndex);
        if (cell != null && column != null) {
            String format = column.getFormat();
            String value = CUtilString.isValid((String)format) ? new DecimalFormat(format).format(theValue) : CUtilDouble.toString((double)theValue);
            JLabel label = new JLabel(value);
            label.setHorizontalAlignment(4);
            component = label;
        }
        if (cell != null) {
            this.handleBackground(component, cell, aIsSelected);
            this.handleForeground(component, cell, aIsSelected);
            this.handleBorder(component, cell, aHasFocus);
            this.handleFont(component, cell);
        }
        return component;
    }
}

